/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind.call.property;

import com.labymedia.ultralight.databind.call.property.PropertyCaller;
import com.labymedia.ultralight.javascript.interop.JavascriptInteropException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectivePropertyCaller
implements PropertyCaller {
    @Override
    public Object callMethod(Object instance, Method method, Object[] parameters) throws JavascriptInteropException {
        try {
            return method.invoke(instance, parameters);
        }
        catch (IllegalAccessException exception) {
            throw new JavascriptInteropException("Unable to access method: " + method.getName(), (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw new JavascriptInteropException(method.getName() + " threw an exception", (Throwable)exception);
        }
    }

    @Override
    public Object callConstructor(Constructor<?> constructor, Object[] parameters) throws JavascriptInteropException {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException exception) {
            throw new JavascriptInteropException("Unable to access constructor: " + constructor.getName(), (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            throw new JavascriptInteropException("Constructor threw an exception", (Throwable)exception);
        }
        catch (InstantiationException exception) {
            throw new JavascriptInteropException("Unable to create instance", (Throwable)exception);
        }
    }

    @Override
    public Object callFieldGet(Object instance, Field field) throws JavascriptInteropException {
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException exception) {
            throw new JavascriptInteropException("Unable to access field: " + field.getName(), (Throwable)exception);
        }
    }

    @Override
    public void callFieldSet(Object instance, Field field, Object value) throws JavascriptInteropException {
        try {
            field.set(instance, value);
        }
        catch (IllegalAccessException exception) {
            throw new JavascriptInteropException("Unable to access field: " + field.getName(), (Throwable)exception);
        }
    }

    public static class Factory
    implements PropertyCaller.Factory {
        @Override
        public ReflectivePropertyCaller create() {
            return new ReflectivePropertyCaller();
        }
    }
}

