/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind.utils;

import com.labymedia.ultralight.databind.Databind;
import com.labymedia.ultralight.databind.context.ContextProvider;
import com.labymedia.ultralight.databind.utils.FunctionalInvocationHandler;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class FunctionalInterfaceBinder {
    public static Object bind(Databind databind, Class<?> target, JavascriptObject function) {
        if (!target.isAnnotationPresent(FunctionalInterface.class)) {
            throw new IllegalArgumentException(target.getName() + " is not a functional interface");
        }
        if (!function.isFunction()) {
            throw new IllegalArgumentException(function.toString() + " is not a function");
        }
        Method bindMethod = null;
        for (Method m : target.getMethods()) {
            if (m.isDefault()) continue;
            bindMethod = m;
        }
        if (bindMethod == null) {
            throw new IllegalArgumentException(target.getName() + " only contains default methods");
        }
        ContextProvider contextProvider = databind.getContextProviderFactory().bindProvider((JavascriptValue)function);
        return Proxy.newProxyInstance(target.getClassLoader(), new Class[]{target}, (InvocationHandler)new FunctionalInvocationHandler(function, target, contextProvider, databind));
    }
}

