/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind.utils;

import com.labymedia.ultralight.databind.Databind;
import com.labymedia.ultralight.databind.context.ContextProvider;
import com.labymedia.ultralight.ffi.gc.DeletableObject;
import com.labymedia.ultralight.javascript.JavascriptContext;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptProtectedValue;
import com.labymedia.ultralight.javascript.JavascriptValue;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

class FunctionalInvocationHandler
implements InvocationHandler {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private final Object lock;
    private final Class<?> target;
    private final ContextProvider contextProvider;
    private final Databind databind;
    private final DeletableObject<ValueWrapper> protectedValue;

    private static Object invokeDefaultMethod(Class<?> clazz, Method method, Object proxy, Object[] args) throws Throwable {
        return LOOKUP.in(clazz).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
    }

    public FunctionalInvocationHandler(JavascriptObject function, Class<?> target, ContextProvider contextProvider, Databind databind) {
        this.target = target;
        this.contextProvider = contextProvider;
        this.databind = databind;
        this.lock = new Object();
        this.protectedValue = new DeletableObject((Object)new ValueWrapper(contextProvider, function.protect()), FunctionalInvocationHandler::delete);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.isDefault()) {
            return FunctionalInvocationHandler.invokeDefaultMethod(this.target, method, proxy, args);
        }
        Class<?> methodSource = method.getDeclaringClass();
        if (methodSource.isInstance(this)) {
            return method.invoke((Object)this, args);
        }
        CompletableFuture future = new CompletableFuture();
        this.contextProvider.syncWithJavascript(contextLock -> {
            try {
                Object object = this.lock;
                synchronized (object) {
                    JavascriptContext context = contextLock.getContext();
                    JavascriptObject object2 = ((ValueWrapper)this.protectedValue.get()).value.revive(contextLock).toObject();
                    JavascriptValue[] arguments = new JavascriptValue[args.length];
                    for (int i = 0; i < arguments.length; ++i) {
                        arguments[i] = this.databind.getConversionUtils().toJavascript(context, args[i]);
                    }
                    ((ValueWrapper)this.protectedValue.get()).value = object2.protect();
                    JavascriptValue returnValue = object2.callAsFunction(null, arguments);
                    future.complete(this.databind.getConversionUtils().fromJavascript(returnValue, returnValue.getClass()));
                }
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        if (CompletableFuture.class.isAssignableFrom(method.getReturnType())) {
            return future;
        }
        try {
            return future.get();
        }
        catch (ExecutionException exception) {
            Throwable t = exception.getCause();
            if (t instanceof RuntimeException || t instanceof Error) {
                throw t;
            }
            Class<?> throwableClass = t.getClass();
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (!exceptionType.isAssignableFrom(throwableClass)) continue;
                throw t;
            }
            throw new RuntimeException("Exception thrown while invoking Javascript method", t);
        }
    }

    private static void delete(ValueWrapper valueWrapper) {
        valueWrapper.contextProvider.syncWithJavascript(contextLock -> valueWrapper.value.revive(contextLock));
    }

    private static class ValueWrapper {
        private final ContextProvider contextProvider;
        private JavascriptProtectedValue value;

        private ValueWrapper(ContextProvider contextProvider, JavascriptProtectedValue value) {
            this.contextProvider = contextProvider;
            this.value = value;
        }
    }
}

