/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.databind.utils;

import com.labymedia.ultralight.databind.Databind;
import com.labymedia.ultralight.databind.DatabindJavascriptClass;
import com.labymedia.ultralight.databind.utils.FunctionalInterfaceBinder;
import com.labymedia.ultralight.javascript.JavascriptClass;
import com.labymedia.ultralight.javascript.JavascriptContext;
import com.labymedia.ultralight.javascript.JavascriptObject;
import com.labymedia.ultralight.javascript.JavascriptType;
import com.labymedia.ultralight.javascript.JavascriptValue;
import java.lang.reflect.Array;
import java.util.Date;

public final class JavascriptConversionUtils {
    private final Databind databind;

    public JavascriptConversionUtils(Databind databind) {
        this.databind = databind;
    }

    public JavascriptValue toJavascript(JavascriptContext context, Object object) {
        return this.toJavascript(context, object, object != null ? object.getClass() : null);
    }

    public JavascriptValue toJavascript(JavascriptContext context, Object object, Class<?> javaClass) {
        if (object == null || object == JavascriptType.NULL) {
            return context.makeNull();
        }
        if (object == JavascriptType.UNDEFINED) {
            return context.makeUndefined();
        }
        if ((javaClass = JavascriptConversionUtils.toWrapperClass(javaClass)) == Boolean.class) {
            return context.makeBoolean(((Boolean)object).booleanValue());
        }
        if (Number.class.isAssignableFrom(javaClass)) {
            return context.makeNumber(((Number)object).doubleValue());
        }
        if (javaClass == String.class) {
            return context.makeString((String)object);
        }
        if (javaClass.isArray()) {
            int length = Array.getLength(object);
            JavascriptValue[] values = new JavascriptValue[length];
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(object, i);
                values[i] = this.toJavascript(context, value, value.getClass());
            }
            return context.makeArray(values);
        }
        if (object instanceof Date) {
            return context.makeDate(new JavascriptValue[]{context.makeNumber((double)((Date)object).getTime())});
        }
        if (object instanceof JavascriptValue) {
            JavascriptValue value = (JavascriptValue)object;
            if (value.isObject()) {
                return value instanceof JavascriptObject ? (JavascriptObject)value : value.toObject();
            }
            return value;
        }
        if (javaClass == Class.class) {
            return context.makeObject(this.databind.toJavascript(javaClass, true), (Object)new DatabindJavascriptClass.Data(null, javaClass));
        }
        if (javaClass == JavascriptClass.class) {
            return context.makeObject((JavascriptClass)object, (Object)new DatabindJavascriptClass.Data(null, javaClass));
        }
        return context.makeObject(this.databind.toJavascript(javaClass), (Object)new DatabindJavascriptClass.Data(object, javaClass));
    }

    public Object fromJavascript(JavascriptValue value, Class<?> type) {
        JavascriptType javascriptType = value.getType();
        if (type == JavascriptValue.class) {
            return value;
        }
        if (type == JavascriptObject.class) {
            if (javascriptType != JavascriptType.OBJECT) {
                throw new IllegalArgumentException("Can not convert a non-object Javascript value to " + type.getName());
            }
            return value instanceof JavascriptObject ? (JavascriptObject)value : value.toObject();
        }
        if (javascriptType == JavascriptType.NULL || javascriptType == JavascriptType.UNDEFINED || type == Void.TYPE || type == Void.class || type == null) {
            if (type != null && type.isPrimitive() && type != Void.TYPE) {
                throw new IllegalArgumentException("Can not convert " + (javascriptType == JavascriptType.NULL ? "null" : "undefined") + " to " + type.getName());
            }
            return null;
        }
        type = JavascriptConversionUtils.toPrimitiveClass(type);
        if (javascriptType == JavascriptType.BOOLEAN) {
            if (type != Boolean.TYPE && type != Object.class) {
                throw new IllegalArgumentException("Can not convert Javascript boolean to " + type.getName());
            }
            return value.toBoolean();
        }
        if (javascriptType == JavascriptType.NUMBER) {
            Double number = value.toNumber();
            if (type == Object.class) {
                return number;
            }
            if (type == Byte.TYPE) {
                return ((Number)number).byteValue();
            }
            if (type == Short.TYPE) {
                return ((Number)number).shortValue();
            }
            if (type == Integer.TYPE) {
                return ((Number)number).intValue();
            }
            if (type == Long.TYPE) {
                return ((Number)number).longValue();
            }
            if (type == Float.TYPE) {
                return Float.valueOf(((Number)number).floatValue());
            }
            if (type == Double.TYPE) {
                return (double)number;
            }
            if (type == Character.TYPE) {
                return Character.valueOf((char)((Number)number).shortValue());
            }
            throw new IllegalArgumentException("Can not convert Javascript number to " + type.getName());
        }
        if (javascriptType == JavascriptType.STRING) {
            String str = value.toString();
            if (type.isAssignableFrom(String.class) || type == Object.class) {
                return str;
            }
            if (type == char[].class) {
                return str.toCharArray();
            }
            if (type == Character[].class) {
                char[] primitiveArray = str.toCharArray();
                Character[] objectArray = new Character[primitiveArray.length];
                for (int i = 0; i < primitiveArray.length; ++i) {
                    objectArray[i] = Character.valueOf(primitiveArray[i]);
                }
                return objectArray;
            }
            throw new IllegalArgumentException("Can not convert Javascript string to " + type.getName());
        }
        if (javascriptType == JavascriptType.OBJECT) {
            JavascriptObject object = value.toObject();
            if (value.isDate()) {
                if (!type.isAssignableFrom(Date.class)) {
                    throw new IllegalArgumentException("Can not convert Javascript date to " + type.getName());
                }
                long millis = (long)object.getProperty("getTime").toObject().callAsFunction(value.toObject(), new JavascriptValue[0]).toNumber();
                return new Date(millis);
            }
            if (value.isArray()) {
                boolean anyType;
                boolean bl = anyType = type == Object.class;
                if (!type.isArray() && !anyType) {
                    throw new IllegalArgumentException("Can not convert a Javascript array to " + type.getName());
                }
                int size = (int)object.getProperty("length").toNumber();
                Class componentType = anyType ? Object.class : type.getComponentType();
                Object objects = Array.newInstance(componentType, size);
                for (int i = 0; i < size; ++i) {
                    Array.set(objects, i, this.fromJavascript(object.getPropertyAtIndex((long)i), componentType));
                }
                return objects;
            }
            if (this.databind.supportsFunctionalConversion() && object.isFunction() && type.isInterface() && type.isAnnotationPresent(FunctionalInterface.class)) {
                return FunctionalInterfaceBinder.bind(this.databind, type, object);
            }
            DatabindJavascriptClass.Data privateData = (DatabindJavascriptClass.Data)object.getPrivate();
            if (privateData == null) {
                if (type == Object.class) {
                    return value;
                }
                throw new IllegalArgumentException("Can not convert a non Java constructed Javascript object to " + type.getName());
            }
            if (privateData.instance() == null) {
                if (!type.isAssignableFrom(Class.class) && type != Object.class) {
                    throw new IllegalArgumentException("Can not convert a Java class to " + type.getName());
                }
                return privateData.javaClass();
            }
            Object javaInstance = privateData.instance();
            if (!type.isAssignableFrom(javaInstance.getClass())) {
                throw new IllegalArgumentException("Can not convert a " + javaInstance.getClass().getName() + " to " + type.getName());
            }
            return javaInstance;
        }
        if (type == Object.class) {
            return value;
        }
        throw new IllegalArgumentException("Can not convert Javascript value to " + type.getName());
    }

    public static Class<?> determineType(JavascriptValue value) {
        JavascriptType type = value.getType();
        if (type == JavascriptType.NULL || type == JavascriptType.UNDEFINED) {
            return null;
        }
        if (type == JavascriptType.BOOLEAN) {
            return Boolean.TYPE;
        }
        if (type == JavascriptType.NUMBER) {
            return Number.class;
        }
        if (type == JavascriptType.STRING) {
            return String.class;
        }
        if (type == JavascriptType.OBJECT) {
            JavascriptObject object = value.toObject();
            if (value.isDate()) {
                return Date.class;
            }
            if (value.isArray()) {
                int size = (int)object.getProperty("length").toNumber();
                JavascriptValue[] values = new JavascriptValue[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = object.getPropertyAtIndex((long)i);
                }
                return Array.newInstance(JavascriptConversionUtils.findCommonSuperclass(values), 0).getClass();
            }
            if (object.getPrivate() == null) {
                return JavascriptObject.class;
            }
            DatabindJavascriptClass.Data privateData = (DatabindJavascriptClass.Data)object.getPrivate();
            if (privateData.instance() == null) {
                return privateData.javaClass();
            }
            return privateData.instance().getClass();
        }
        throw new AssertionError((Object)"UNREACHABLE: Could not convert JavascriptValue to any java class");
    }

    private static Class<?> findCommonSuperclass(JavascriptValue ... values) {
        Class commonSuperclass;
        Class[] classes = new Class[values.length];
        for (int i = 0; i < classes.length; ++i) {
            Class<?> type = JavascriptConversionUtils.determineType(values[i]);
            classes[i] = type == null ? Object.class : type;
        }
        block1: for (commonSuperclass = classes[0]; commonSuperclass != Object.class; commonSuperclass = commonSuperclass.getSuperclass()) {
            for (int i = 1; i < classes.length; ++i) {
                if (!commonSuperclass.isAssignableFrom(classes[i])) continue block1;
            }
            return commonSuperclass;
        }
        return commonSuperclass;
    }

    private static Class<?> toPrimitiveClass(Class<?> source) {
        if (source.isPrimitive()) {
            return source;
        }
        if (source == Boolean.class) {
            return Boolean.TYPE;
        }
        if (source == Byte.class) {
            return Byte.TYPE;
        }
        if (source == Character.class) {
            return Character.TYPE;
        }
        if (source == Short.class) {
            return Short.TYPE;
        }
        if (source == Integer.class) {
            return Integer.TYPE;
        }
        if (source == Long.class) {
            return Long.TYPE;
        }
        if (source == Float.class) {
            return Float.TYPE;
        }
        if (source == Double.class) {
            return Double.TYPE;
        }
        return source;
    }

    private static Class<?> toWrapperClass(Class<?> source) {
        if (!source.isPrimitive()) {
            return source;
        }
        if (source == Boolean.TYPE) {
            return Boolean.class;
        }
        if (source == Byte.TYPE) {
            return Byte.class;
        }
        if (source == Character.TYPE) {
            return Character.class;
        }
        if (source == Short.TYPE) {
            return Short.class;
        }
        if (source == Integer.TYPE) {
            return Integer.class;
        }
        if (source == Long.TYPE) {
            return Long.class;
        }
        if (source == Float.TYPE) {
            return Float.class;
        }
        if (source == Double.TYPE) {
            return Double.class;
        }
        throw new AssertionError((Object)"UNREACHABLE: Primitive class passed, but no wrapper class known");
    }
}

