/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.util;

import com.labymedia.ultralight.UltralightPlatform;
import com.labymedia.ultralight.util.UltralightGlfwOpenGLWindow;
import com.labymedia.ultralight.util.UltralightOpenGLGPUDriver;
import com.labymedia.ultralight.util.UltralightRendererInstanceHolder;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.lwjgl.opengl.GL;

public class UltralightGlfwOpenGLContext {
    private final UltralightThread thread;
    private final Collection<UltralightGlfwOpenGLWindow> subWindows;
    private final UltralightOpenGLGPUDriver driver;
    private UltralightPlatform platform;
    private UltralightGlfwOpenGLWindow mainWindow;

    private UltralightGlfwOpenGLContext(int mainWindowWidth, int mainWindowHeight, String mainWindowTitle, UltralightOpenGLGPUDriver driver, long parentWindow) {
        this.driver = driver;
        this.thread = new UltralightThread();
        this.subWindows = new HashSet<UltralightGlfwOpenGLWindow>();
        this.initialize(mainWindowWidth, mainWindowHeight, mainWindowTitle, parentWindow);
    }

    private void initialize(int mainWindowWidth, int mainWindowHeight, String mainWindowTitle, long parentWindow) {
        this.mainWindow = UltralightGlfwOpenGLWindow.create(this, mainWindowWidth, mainWindowHeight, mainWindowTitle, parentWindow);
        this.postAndWait(() -> {
            this.mainWindow.makeContext();
            GL.createCapabilities();
            this.platform = UltralightPlatform.instance();
            this.driver.initialize(this);
        });
    }

    public Future<?> post(Runnable runnable) {
        return this.thread.post(runnable);
    }

    public <R> Future<R> post(Callable<R> callable) {
        return this.thread.post(callable);
    }

    public UltralightGlfwOpenGLContext postAndWait(Runnable runnable) {
        this.thread.postAndWait(runnable);
        return this;
    }

    public <R> R postAndWait(Callable<R> callable) {
        return this.thread.postAndWait(callable);
    }

    public UltralightGlfwOpenGLContext postAndWait(Consumer<UltralightGlfwOpenGLContext> consumer) {
        this.thread.postAndWait(() -> consumer.accept(this));
        return this;
    }

    public UltralightGlfwOpenGLWindow getMainWindow() {
        return this.mainWindow;
    }

    public Collection<UltralightGlfwOpenGLWindow> getSubWindows() {
        return this.subWindows;
    }

    public synchronized UltralightGlfwOpenGLWindow createSubWindow(int width, int height, String title) {
        UltralightGlfwOpenGLWindow window = UltralightGlfwOpenGLWindow.create(this, width, height, title, this.getMainWindow().getParentWindow());
        this.subWindows.add(window);
        return window;
    }

    public static UltralightGlfwOpenGLContext create(int mainWindowWidth, int mainWindowHeight, String mainWindowTitle, UltralightOpenGLGPUDriver driver) {
        return new UltralightGlfwOpenGLContext(mainWindowWidth, mainWindowHeight, mainWindowTitle, driver, 0L);
    }

    public static UltralightGlfwOpenGLContext create(int mainWindowWidth, int mainWindowHeight, String mainWindowTitle, UltralightOpenGLGPUDriver driver, long parentWindow) {
        return new UltralightGlfwOpenGLContext(mainWindowWidth, mainWindowHeight, mainWindowTitle, driver, parentWindow);
    }

    public UltralightPlatform getPlatform() {
        return this.platform;
    }

    public UltralightGlfwOpenGLContext updateJavaScript() {
        this.postAndWait(() -> UltralightRendererInstanceHolder.getRenderer().update());
        return this;
    }

    public UltralightGlfwOpenGLContext updateWebContent(UltralightGlfwOpenGLWindow window) {
        this.postAndWait(() -> this.driver.renderTexture(window));
        return this;
    }

    public UltralightGlfwOpenGLContext bindTexture(UltralightGlfwOpenGLWindow window) {
        this.driver.bindTexture(window);
        return this;
    }

    public UltralightOpenGLGPUDriver getDriver() {
        return this.driver;
    }

    public boolean isOnUltralightThread() {
        return this.thread.isOnUltralightThread();
    }

    private static class UltralightThreadFactory
    implements ThreadFactory {
        private UltralightThread thread;

        private UltralightThreadFactory(UltralightThread thread) {
            this.thread = thread;
        }

        @Override
        public Thread newThread(Runnable r) {
            if (this.thread == null) {
                throw new IllegalStateException("Tried to schedule a runnable after Ultralight died");
            }
            UltralightThread created = this.thread;
            this.thread = null;
            created.setDelegate(r);
            return created;
        }
    }

    private static class UltralightThread
    extends Thread {
        private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new UltralightThreadFactory(this));
        private Runnable delegate;

        public UltralightThread() {
            this.setName("Ultralight Thread");
        }

        public Future<?> post(Runnable runnable) {
            if (this.isOnUltralightThread()) {
                FutureTask<Object> task = new FutureTask<Object>(runnable, null);
                task.run();
                return task;
            }
            return this.executorService.submit(runnable);
        }

        public <R> Future<R> post(Callable<R> callable) {
            if (this.isOnUltralightThread()) {
                FutureTask<R> task = new FutureTask<R>(callable);
                task.run();
                return task;
            }
            return this.executorService.submit(callable);
        }

        public <R> R postAndWait(Callable<R> callable) {
            try {
                return this.post(callable).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException("Exception while executing task on web thread", e);
            }
        }

        public void postAndWait(Runnable runnable) {
            try {
                this.post(runnable).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException("Exception while executing task on web thread", e);
            }
        }

        public boolean isOnUltralightThread() {
            return Thread.currentThread().equals(this);
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        public void setDelegate(Runnable delegate) {
            this.delegate = delegate;
        }
    }
}

