/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.util;

import com.labymedia.ultralight.gpu.UltralightOpenGLGPUDriverNative;
import com.labymedia.ultralight.plugin.render.UltralightGPUDriverNative;
import com.labymedia.ultralight.util.UltralightGlfwOpenGLContext;
import com.labymedia.ultralight.util.UltralightGlfwOpenGLWindow;
import com.labymedia.ultralight.util.UltralightOpenGLGPUDriver;
import com.labymedia.ultralight.util.UltralightRendererInstanceHolder;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;

public class UltralightGlfwOpenGLGPUDriver
implements UltralightOpenGLGPUDriver {
    private final boolean msaa;
    private UltralightOpenGLGPUDriverNative driverNative;
    private UltralightGlfwOpenGLContext context;

    private UltralightGlfwOpenGLGPUDriver(boolean msaa) {
        this.msaa = msaa;
    }

    @Override
    public void initialize(UltralightGlfwOpenGLContext context) {
        this.driverNative = new UltralightOpenGLGPUDriverNative(context.getMainWindow().getWindowHandle(), this.msaa, GLFW.Functions.GetProcAddress);
        this.context = context;
        this.context.getPlatform().setGPUDriver((UltralightGPUDriverNative)this.driverNative);
    }

    @Override
    public void renderTexture(UltralightGlfwOpenGLWindow window) {
        this.context.postAndWait(() -> {
            this.driverNative.setActiveWindow(window.getWindowHandle());
            UltralightRendererInstanceHolder.getRenderer().render();
            if (this.driverNative.hasCommandsPending()) {
                this.driverNative.drawCommandList();
            }
            GL11.glFinish();
        });
    }

    @Override
    public void bindTexture(UltralightGlfwOpenGLWindow window) {
        this.driverNative.bindTexture(0L, window.postAndWait(() -> window.getView().renderTarget().getTextureId()).longValue());
    }

    public static UltralightGlfwOpenGLGPUDriver create(boolean msaa) {
        return new UltralightGlfwOpenGLGPUDriver(msaa);
    }
}

