/*
 * Decompiled with CFR 0.152.
 */
package com.labymedia.ultralight.util;

import com.labymedia.ultralight.UltralightView;
import com.labymedia.ultralight.config.UltralightViewConfig;
import com.labymedia.ultralight.util.UltralightGlfwOpenGLContext;
import com.labymedia.ultralight.util.UltralightRendererInstanceHolder;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.lwjgl.glfw.GLFW;

public class UltralightGlfwOpenGLWindow {
    private final long parentWindow;
    private final UltralightGlfwOpenGLContext context;
    private long windowHandle;
    private UltralightView view;

    private UltralightGlfwOpenGLWindow(UltralightGlfwOpenGLContext context, int width, int height, String title, long sharedWindow) {
        this.context = context;
        this.parentWindow = sharedWindow;
        this.initialize(width, height, title);
    }

    private void initialize(int width, int height, String title) {
        GLFW.glfwWindowHint((int)131076, (int)0);
        this.windowHandle = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)title, (long)0L, (long)this.parentWindow);
    }

    private UltralightView createView() {
        return UltralightRendererInstanceHolder.getRenderer().createView((long)this.getWidth(), (long)this.getHeight(), new UltralightViewConfig().isAccelerated(true).isTransparent(true));
    }

    public UltralightView getView() {
        if (this.view == null) {
            this.view = this.createView();
        }
        return this.view;
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }

    public UltralightGlfwOpenGLWindow updateWebContent() {
        this.context.updateWebContent(this);
        return this;
    }

    public UltralightGlfwOpenGLContext getContext() {
        return this.context;
    }

    public static UltralightGlfwOpenGLWindow create(UltralightGlfwOpenGLContext context, int width, int height, String title) {
        return new UltralightGlfwOpenGLWindow(context, width, height, title, 0L);
    }

    public static UltralightGlfwOpenGLWindow create(UltralightGlfwOpenGLContext context, int width, int height, String title, long parentWindow) {
        return new UltralightGlfwOpenGLWindow(context, width, height, title, parentWindow);
    }

    public Future<?> post(Runnable runnable) {
        return this.getContext().post(runnable);
    }

    public <R> Future<R> post(Callable<R> callable) {
        return this.getContext().post(callable);
    }

    public <R> R postAndWait(Callable<R> callable) {
        return this.getContext().postAndWait(callable);
    }

    public UltralightGlfwOpenGLWindow postAndWait(Runnable runnable) {
        this.getContext().postAndWait(runnable);
        return this;
    }

    public UltralightGlfwOpenGLWindow postAndWait(Consumer<UltralightGlfwOpenGLWindow> runnable) {
        this.getContext().postAndWait(() -> runnable.accept(this));
        return this;
    }

    public UltralightGlfwOpenGLWindow show() {
        this.context.postAndWait(() -> GLFW.glfwShowWindow((long)this.windowHandle));
        return this;
    }

    public UltralightGlfwOpenGLWindow makeContext() {
        this.context.postAndWait(() -> GLFW.glfwMakeContextCurrent((long)this.windowHandle));
        return this;
    }

    public UltralightGlfwOpenGLWindow swapBuffers() {
        this.context.postAndWait(() -> GLFW.glfwSwapBuffers((long)this.windowHandle));
        return this;
    }

    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.windowHandle);
    }

    public UltralightGlfwOpenGLWindow close() {
        this.context.postAndWait(() -> GLFW.glfwDestroyWindow((long)this.windowHandle));
        return this;
    }

    public int getWidth() {
        return this.context.postAndWait(() -> {
            int[] width = new int[]{0};
            int[] height = new int[]{0};
            GLFW.glfwGetWindowSize((long)this.windowHandle, (int[])width, (int[])height);
            return width[0];
        });
    }

    public int getHeight() {
        return this.context.postAndWait(() -> {
            int[] width = new int[]{0};
            int[] height = new int[]{0};
            GLFW.glfwGetWindowSize((long)this.windowHandle, (int[])width, (int[])height);
            return height[0];
        });
    }

    public void loadUrl(String url) {
        this.getView().loadURL(url);
    }

    public UltralightGlfwOpenGLWindow setView(UltralightView view) {
        this.view = view;
        return this;
    }

    public UltralightGlfwOpenGLWindow bindTexture() {
        this.context.bindTexture(this);
        return this;
    }

    public long getParentWindow() {
        return this.parentWindow;
    }
}

