/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.AuthenticationGetResponse;
import com.lacunasoftware.restpki.AuthenticationPostRequest;
import com.lacunasoftware.restpki.AuthenticationPostResponse;
import com.lacunasoftware.restpki.AuthenticationResult;
import com.lacunasoftware.restpki.AuthenticationsPostRequest;
import com.lacunasoftware.restpki.AuthenticationsPostResponse;
import com.lacunasoftware.restpki.AuthenticationsPostSignedBytesRequest;
import com.lacunasoftware.restpki.AuthenticationsPostSignedBytesResponse;
import com.lacunasoftware.restpki.ClientSideSignatureInstructions;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SecurityContext;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.ValidationResults;
import java.util.UUID;

public class Authentication {
    private RestPkiClient client;
    private boolean ignoreRevocationStatusUnknown = false;
    private boolean done = false;
    private PKCertificate pkCertificate;

    public Authentication(RestPkiClient client) {
        this.client = client;
    }

    public boolean getIgnoreRevocationStatusUnknown() {
        return this.ignoreRevocationStatusUnknown;
    }

    public void setIgnoreRevocationStatusUnknown(boolean ignoreRevocationStatusUnknown) {
        this.ignoreRevocationStatusUnknown = ignoreRevocationStatusUnknown;
    }

    @Deprecated
    public String start() throws RestException {
        AuthenticationGetResponse response = this.client.getRestClient().get("Api/Authentication", AuthenticationGetResponse.class);
        return Util.encodeBase64(response.getNonce());
    }

    public ClientSideSignatureInstructions start2(SecurityContext securityContext) throws RestException {
        AuthenticationsPostRequest request = new AuthenticationsPostRequest();
        if (securityContext != null && securityContext.getId() != null) {
            request.setSecurityContextId(UUID.fromString(securityContext.getId()));
        }
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        AuthenticationsPostResponse response = this.client.getRestClient().post("Api/Authentications", request, AuthenticationsPostResponse.class);
        return new ClientSideSignatureInstructions(response.getToken(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
    }

    public String startWithWebPki(SecurityContext securityContext) throws RestException {
        AuthenticationsPostRequest request = new AuthenticationsPostRequest();
        if (securityContext != null && securityContext.getId() != null) {
            request.setSecurityContextId(UUID.fromString(securityContext.getId()));
        }
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        AuthenticationsPostResponse response = this.client.getRestClient().post("Api/Authentications", request, AuthenticationsPostResponse.class);
        return response.getToken();
    }

    @Deprecated
    public ValidationResults complete(String nonce, String certificate, String signature, SecurityContext securityContext) throws RestException {
        AuthenticationPostRequest request = new AuthenticationPostRequest();
        if (nonce != null) {
            request.setNonce(Util.decodeBase64(nonce));
        }
        if (certificate != null) {
            request.setCertificate(Util.decodeBase64(certificate));
        }
        if (signature != null) {
            request.setSignature(Util.decodeBase64(signature));
        }
        if (securityContext != null && securityContext.getId() != null) {
            request.setSecurityContextId(UUID.fromString(securityContext.getId()));
        }
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        AuthenticationPostResponse response = this.client.getRestClient().post("Api/Authentication", request, AuthenticationPostResponse.class);
        ValidationResults vr = new ValidationResults(response.getValidationResults());
        if (response.getCertificate() != null) {
            this.pkCertificate = new PKCertificate(response.getCertificate());
        }
        this.done = true;
        return vr;
    }

    public AuthenticationResult complete2(String token, String certificate, String signature) throws RestException {
        AuthenticationsPostSignedBytesRequest request = new AuthenticationsPostSignedBytesRequest();
        if (certificate != null) {
            request.setCertificate(Util.decodeBase64(certificate));
        }
        if (signature != null) {
            request.setSignature(Util.decodeBase64(signature));
        }
        AuthenticationsPostSignedBytesResponse response = this.client.getRestClient().post(String.format("/Api/Authentications/%s/SignedBytes", token), request, AuthenticationsPostSignedBytesResponse.class);
        ValidationResults vr = new ValidationResults(response.getValidationResults());
        PKCertificate cert = null;
        if (response.getCertificate() != null) {
            cert = new PKCertificate(response.getCertificate());
        }
        return new AuthenticationResult(cert, vr);
    }

    public ValidationResults completeWithWebPki(String token) throws RestException {
        AuthenticationsPostSignedBytesResponse response = this.client.getRestClient().post("Api/Authentications/" + token + "/Finalize", null, AuthenticationsPostSignedBytesResponse.class);
        ValidationResults vr = new ValidationResults(response.getValidationResults());
        if (response.getCertificate() != null) {
            this.pkCertificate = new PKCertificate(response.getCertificate());
        }
        this.done = true;
        return vr;
    }

    public PKCertificate getPKCertificate() {
        if (!this.done) {
            throw new RuntimeException("The method getPKCertificate() can only be called after calling one of the complete methods");
        }
        return this.pkCertificate;
    }
}

