/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.CadesSignature;
import com.lacunasoftware.restpki.CadesSignatureModel;
import com.lacunasoftware.restpki.DigestAlgorithm;
import com.lacunasoftware.restpki.DigestAlgorithmAndValueModel;
import com.lacunasoftware.restpki.FileModel;
import com.lacunasoftware.restpki.OpenSignatureRequestModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureExplorer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CadesSignatureExplorer
extends SignatureExplorer {
    private static final String CMS_SIGNATURE_MIME_TYPE = "application/pkcs7-signature";
    private Path dataFilePath;
    private InputStream dataFileStream;

    public CadesSignatureExplorer(RestPkiClient client) {
        super(client);
    }

    public void setDataFile(String path) {
        this.setDataFile(Paths.get(path, new String[0]));
    }

    public void setDataFile(Path path) {
        this.dataFilePath = path;
    }

    public void setDataFile(InputStream stream) {
        this.dataFileStream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CadesSignature open() throws RestException, IOException {
        List<DigestAlgorithm> requiredHashes;
        if (this.signatureFileContent == null) {
            throw new RuntimeException("The signature file to open was not set");
        }
        List<DigestAlgorithmAndValueModel> dataHashes = null;
        if ((this.dataFileStream != null || this.dataFilePath != null) && (requiredHashes = this.getRequiredHashes()).size() > 0) {
            if (this.dataFileStream != null) {
                dataHashes = this.computeDataHashes(this.dataFileStream, requiredHashes);
            } else {
                try (InputStream fileStream = Files.newInputStream(this.dataFilePath, new OpenOption[0]);){
                    dataHashes = this.computeDataHashes(fileStream, requiredHashes);
                }
            }
        }
        OpenSignatureRequestModel request = this.getRequest(CMS_SIGNATURE_MIME_TYPE);
        request.setDataHashes(dataHashes);
        CadesSignatureModel response = this.client.getRestClient().post("Api/CadesSignatures/Open", request, CadesSignatureModel.class);
        CadesSignature signature = new CadesSignature(response);
        return signature;
    }

    private List<DigestAlgorithm> getRequiredHashes() throws RestException {
        FileModel request = new FileModel();
        request.setContent(this.signatureFileContent);
        request.setMimeType(CMS_SIGNATURE_MIME_TYPE);
        List<Object> response = Arrays.asList((Object[])this.client.getRestClient().post("Api/CadesSignatures/RequiredHashes", request, DigestAlgorithmAndValueModel.AlgorithmEnum[].class));
        ArrayList<DigestAlgorithm> algs = new ArrayList<DigestAlgorithm>();
        for (DigestAlgorithmAndValueModel.AlgorithmEnum algorithmEnum : response) {
            algs.add(DigestAlgorithm.getInstanceByApiModel(algorithmEnum));
        }
        return algs;
    }

    private List<DigestAlgorithmAndValueModel> computeDataHashes(InputStream dataFileStream, List<DigestAlgorithm> algorithms) throws IOException {
        ArrayList<DigestInputStream> digestStreams = new ArrayList<DigestInputStream>();
        InputStream outermostStream = dataFileStream;
        for (DigestAlgorithm digestAlg : algorithms) {
            DigestInputStream digestStream = new DigestInputStream(outermostStream, digestAlg.getSpi());
            digestStreams.add(digestStream);
            outermostStream = digestStream;
        }
        byte[] buffer = new byte[8192];
        while (outermostStream.read(buffer) != -1) {
        }
        ArrayList<DigestAlgorithmAndValueModel> dataHashes = new ArrayList<DigestAlgorithmAndValueModel>();
        for (int i = 0; i < algorithms.size(); ++i) {
            DigestAlgorithm digestAlg = algorithms.get(i);
            DigestInputStream digestStream = (DigestInputStream)digestStreams.get(i);
            byte[] digestValue = digestStream.getMessageDigest().digest();
            DigestAlgorithmAndValueModel dataHash = new DigestAlgorithmAndValueModel();
            dataHash.setAlgorithm(digestAlg.getDigestAlgorithmAndValueModelEnum());
            dataHash.setValue(digestValue);
            dataHashes.add(dataHash);
        }
        return dataHashes;
    }
}

