/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.CadesSignature;
import com.lacunasoftware.restpki.CadesSignatureModel;
import com.lacunasoftware.restpki.CadesSignatureWithEncapsulatedContent;
import com.lacunasoftware.restpki.DigestAlgorithm;
import com.lacunasoftware.restpki.DigestAlgorithmAndValueModel;
import com.lacunasoftware.restpki.FileModel;
import com.lacunasoftware.restpki.FileRef;
import com.lacunasoftware.restpki.FileResult;
import com.lacunasoftware.restpki.OpenCadesSignatureRequestModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureExplorer2;
import com.lacunasoftware.restpki.SignaturePolicy;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class CadesSignatureExplorer2
extends SignatureExplorer2 {
    private static final String CMS_SIGNATURE_MIME_TYPE = "application/pkcs7-signature";
    private FileRef dataFile;

    public CadesSignatureExplorer2(RestPkiClient client) {
        super(client);
    }

    public void setDataFile(String path) {
        this.setDataFile(Paths.get(path, new String[0]));
    }

    public void setDataFile(Path path) {
        this.dataFile = FileRef.fromFile(path);
    }

    public void setDataFile(InputStream stream) {
        this.dataFile = FileRef.fromStream(stream);
    }

    public void setDataFile(byte[] content) {
        this.dataFile = FileRef.fromContent(content);
    }

    public CadesSignature open() throws RestException, IOException {
        OpenCadesSignatureRequestModel request = this.getRequest(false);
        CadesSignatureModel response = this.client.getRestClient().post("Api/CadesSignatures/Open", request, CadesSignatureModel.class);
        CadesSignature signature = new CadesSignature(response);
        return signature;
    }

    public CadesSignatureWithEncapsulatedContent openAndExtractContent() throws RestException, IOException {
        OpenCadesSignatureRequestModel request = this.getRequest(true);
        CadesSignatureModel response = this.client.getRestClient().post("Api/CadesSignatures/Open", request, CadesSignatureModel.class);
        CadesSignature signature = new CadesSignature(response);
        FileResult encapsulatedContent = new FileResult(this.client, response.getEncapsulatedContent());
        return new CadesSignatureWithEncapsulatedContent(signature, encapsulatedContent);
    }

    private OpenCadesSignatureRequestModel getRequest(boolean extractEncapsulatedContent) throws RestException, IOException {
        List<DigestAlgorithm> requiredHashes;
        if (this.signatureFile == null) {
            throw new RuntimeException("The signature file to open was not set");
        }
        List<DigestAlgorithmAndValueModel> dataHashes = null;
        if (this.dataFile != null && !(requiredHashes = this.getRequiredHashes()).isEmpty()) {
            dataHashes = this.dataFile.computeDataHashes(requiredHashes);
        }
        OpenCadesSignatureRequestModel request = new OpenCadesSignatureRequestModel();
        request.setExtractEncapsulatedContent(extractEncapsulatedContent);
        request.setDataHashes(dataHashes);
        return this.fillRequest(request);
    }

    private OpenCadesSignatureRequestModel fillRequest(OpenCadesSignatureRequestModel request) throws RestException, IOException {
        request.setValidate(this.validate);
        if (this.defaultSignaturePolicyId != null) {
            request.setDefaultSignaturePolicyId(UUID.fromString(this.defaultSignaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setTrustUncertifiedSigningTime(this.trustUncertifiedSigningTime);
        if (this.acceptableExplicitPolicies != null) {
            ArrayList<UUID> policyIds = new ArrayList<UUID>();
            for (SignaturePolicy policy : this.acceptableExplicitPolicies.getPolicies()) {
                policyIds.add(UUID.fromString(policy.getId()));
            }
            request.setAcceptableExplicitPolicies(policyIds);
        }
        request.setFile(this.signatureFile.uploadOrReference(this.client));
        return request;
    }

    private List<DigestAlgorithm> getRequiredHashes() throws RestException, IOException {
        FileModel request = this.signatureFile.uploadOrReference(this.client);
        List<Object> response = Arrays.asList((Object[])this.client.getRestClient().post("Api/CadesSignatures/RequiredHashes", request, DigestAlgorithmAndValueModel.AlgorithmEnum[].class));
        ArrayList<DigestAlgorithm> algs = new ArrayList<DigestAlgorithm>();
        for (DigestAlgorithmAndValueModel.AlgorithmEnum algorithmEnum : response) {
            algs.add(DigestAlgorithm.getInstanceByApiModel(algorithmEnum));
        }
        return algs;
    }
}

