/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.restpki.CadesSignaturePostSignedBytesResponse;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.PadesSignaturePostSignedBytesRequest;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureFinisher;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CadesSignatureFinisher
extends SignatureFinisher {
    private byte[] cms;

    public CadesSignatureFinisher(RestPkiClient client) {
        super(client);
    }

    @Override
    public byte[] finish() throws RestException {
        CadesSignaturePostSignedBytesResponse response;
        if (this.token == null) {
            throw new RuntimeException("The token was not set");
        }
        if (this.signature == null) {
            String actionUrl = String.format("Api/CadesSignatures/%s/Finalize", this.token);
            response = this.client.getRestClient().post(actionUrl, null, CadesSignaturePostSignedBytesResponse.class);
        } else {
            PadesSignaturePostSignedBytesRequest request = new PadesSignaturePostSignedBytesRequest();
            request.setSignature(Util.decodeBase64(this.signature));
            String actionUrl = String.format("Api/CadesSignatures/%s/SignedBytes", this.token);
            response = this.client.getRestClient().post(actionUrl, request, CadesSignaturePostSignedBytesResponse.class);
        }
        this.cms = (byte[])new ObjectMapper().convertValue((Object)response.getCms(), byte[].class);
        this.callbackArgument = response.getCallbackArgument();
        this.certificateInfo = new PKCertificate(response.getCertificate());
        this.done = true;
        return this.cms;
    }

    public byte[] getCms() {
        if (!this.done) {
            throw new RuntimeException("The getCms() method can only be called after calling the finish() method");
        }
        return this.cms;
    }

    public void writeCmsToFile(String path) throws IOException {
        this.writeCmsToFile(Paths.get(path, new String[0]));
    }

    public void writeCmsToFile(Path path) throws IOException {
        if (!this.done) {
            throw new RuntimeException("The writeCmsToFile() method can only be called after calling the finish() method");
        }
        Files.write(path, this.cms, new OpenOption[0]);
    }
}

