/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.restpki.CadesSignaturePostRequest;
import com.lacunasoftware.restpki.CadesSignaturePostResponse;
import com.lacunasoftware.restpki.ClientSideSignatureInstructions;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureStarter;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CadesSignatureStarter
extends SignatureStarter {
    private byte[] contentToSign;
    private byte[] cmsToCoSign;
    private Boolean encapsulateContent;

    public CadesSignatureStarter(RestPkiClient client) {
        super(client);
    }

    public void setContentToSign(InputStream stream) throws IOException {
        this.contentToSign = Util.readStream(stream);
    }

    public void setContentToSign(byte[] content) {
        this.contentToSign = content;
    }

    public void setFileToSign(String path) throws IOException {
        this.setFileToSign(Paths.get(path, new String[0]));
    }

    public void setFileToSign(Path path) throws IOException {
        this.contentToSign = Files.readAllBytes(path);
    }

    public void setCmsToCoSign(InputStream stream) throws IOException {
        this.cmsToCoSign = Util.readStream(stream);
    }

    public void setCmsToCoSign(byte[] cmsToCoSign) {
        this.cmsToCoSign = cmsToCoSign;
    }

    public void setCmsToCoSign(String path) throws IOException {
        this.setCmsToCoSign(Paths.get(path, new String[0]));
    }

    public void setCmsToCoSign(Path path) throws IOException {
        this.cmsToCoSign = Files.readAllBytes(path);
    }

    public void setEncapsulateContent(Boolean encapsulateContent) {
        this.encapsulateContent = encapsulateContent;
    }

    @Override
    public ClientSideSignatureInstructions start() throws RestException {
        CadesSignaturePostResponse response;
        if (this.contentToSign == null && this.cmsToCoSign == null) {
            throw new RuntimeException("The content to sign was not set and no CMS to be co-signed was given");
        }
        if (this.certificate == null) {
            throw new RuntimeException("The certificate was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        CadesSignaturePostRequest request = new CadesSignaturePostRequest();
        request.setCertificate(this.certificate);
        request.setSignaturePolicyId(this.signaturePolicyId);
        request.setSecurityContextId(this.securityContextId);
        request.setCallbackArgument(this.callbackArgument);
        request.setEncapsulateContent(this.encapsulateContent);
        if (this.contentToSign != null) {
            request.setContentToSign((String)new ObjectMapper().convertValue((Object)this.contentToSign, String.class));
        }
        if (this.cmsToCoSign != null) {
            request.setCmsToCoSign((String)new ObjectMapper().convertValue((Object)this.cmsToCoSign, String.class));
        }
        if ((response = this.client.getRestClient().post("Api/CadesSignatures", request, CadesSignaturePostResponse.class)).getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        ClientSideSignatureInstructions signatureInstructions = new ClientSideSignatureInstructions(response.getToken(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
        this.done = true;
        return signatureInstructions;
    }

    @Override
    public String startWithWebPki() throws RestException {
        CadesSignaturePostResponse response;
        if (this.contentToSign == null && this.cmsToCoSign == null) {
            throw new RuntimeException("The content to sign was not set and no CMS to be co-signed was given");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        CadesSignaturePostRequest request = new CadesSignaturePostRequest();
        request.setCertificate(this.certificate);
        request.setSignaturePolicyId(this.signaturePolicyId);
        request.setSecurityContextId(this.securityContextId);
        request.setCallbackArgument(this.callbackArgument);
        request.setEncapsulateContent(this.encapsulateContent);
        if (this.contentToSign != null) {
            request.setContentToSign((String)new ObjectMapper().convertValue((Object)this.contentToSign, String.class));
        }
        if (this.cmsToCoSign != null) {
            request.setCmsToCoSign((String)new ObjectMapper().convertValue((Object)this.cmsToCoSign, String.class));
        }
        if ((response = this.client.getRestClient().post("Api/CadesSignatures", request, CadesSignaturePostResponse.class)).getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        this.done = true;
        return response.getToken();
    }
}

