/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.Apis;
import com.lacunasoftware.restpki.CadesSignaturePostRequestV1;
import com.lacunasoftware.restpki.CadesSignaturePostRequestV2;
import com.lacunasoftware.restpki.CadesSignaturePostRequestV3;
import com.lacunasoftware.restpki.CadesSignaturePostResponse;
import com.lacunasoftware.restpki.DigestAlgorithm;
import com.lacunasoftware.restpki.FileRef;
import com.lacunasoftware.restpki.FileResult;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureStartResult;
import com.lacunasoftware.restpki.SignatureStartWithWebPkiResult;
import com.lacunasoftware.restpki.SignatureStarter2;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CadesSignatureStarter2
extends SignatureStarter2 {
    private FileRef fileToSign;
    private FileRef cmsToCoSign;
    private Boolean encapsulateContent;
    private List<DigestAlgorithm> digestAlgorithmsForDetachedSignature = new ArrayList<DigestAlgorithm>();

    public CadesSignatureStarter2(RestPkiClient client) {
        super(client);
        this.digestAlgorithmsForDetachedSignature.add(DigestAlgorithm.SHA1);
        this.digestAlgorithmsForDetachedSignature.add(DigestAlgorithm.SHA256);
    }

    public void setContentToSign(InputStream stream) {
        this.fileToSign = FileRef.fromStream(stream);
    }

    public void setContentToSign(byte[] content) {
        this.fileToSign = FileRef.fromContent(content);
    }

    public void setFileToSign(String path) {
        this.setFileToSign(Paths.get(path, new String[0]));
    }

    public void setFileToSign(Path path) {
        this.fileToSign = FileRef.fromFile(path);
    }

    public void setCmsToCoSign(InputStream stream) {
        this.cmsToCoSign = FileRef.fromStream(stream);
    }

    public void setCmsToCoSign(byte[] cmsToCoSign) {
        this.cmsToCoSign = FileRef.fromContent(cmsToCoSign);
    }

    public void setCmsToCoSign(String path) {
        this.setCmsToCoSign(Paths.get(path, new String[0]));
    }

    public void setCmsToCoSign(Path path) {
        this.cmsToCoSign = FileRef.fromFile(path);
    }

    @Deprecated
    public void SetCmsToCoSign(FileResult fileResult) {
        this.setCmsToCoSign(fileResult);
    }

    public void setCmsToCoSign(FileResult fileResult) {
        this.cmsToCoSign = FileRef.fromResult(fileResult);
    }

    public void setEncapsulateContent(Boolean encapsulateContent) {
        this.encapsulateContent = encapsulateContent;
    }

    @Override
    public SignatureStartResult start() throws RestException, IOException {
        if (this.certificateBase64 == null) {
            throw new RuntimeException("The certificate was not set");
        }
        CadesSignaturePostResponse response = this.startCommon();
        return new SignatureStartResult(response.getToken(), response.getCertificate(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
    }

    @Override
    public SignatureStartWithWebPkiResult startWithWebPki() throws RestException, IOException {
        CadesSignaturePostResponse response = this.startCommon();
        return new SignatureStartWithWebPkiResult(response.getToken(), response.getCertificate());
    }

    private CadesSignaturePostResponse startCommon() throws RestException, IOException {
        int apiVersion = this.client.getApiVersion(Apis.StartCades);
        switch (apiVersion) {
            case 1: {
                return this.startCommonV1();
            }
            case 2: {
                return this.startCommonV2();
            }
        }
        return this.startCommonV3();
    }

    private CadesSignaturePostResponse startCommonV3() throws RestException, IOException {
        if (this.fileToSign == null && this.cmsToCoSign == null) {
            throw new RuntimeException("The content to sign was not set and no CMS to be co-signed was given");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        CadesSignaturePostRequestV3 request = new CadesSignaturePostRequestV3();
        if (this.certificateBase64 != null) {
            request.setCertificate(Util.decodeBase64(this.certificateBase64));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setCallbackArgument(this.callbackArgument);
        request.setEncapsulateContent(this.encapsulateContent);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        if (this.fileToSign != null) {
            if (!this.encapsulateContent.booleanValue()) {
                request.setDataHashes(this.fileToSign.computeDataHashes(this.digestAlgorithmsForDetachedSignature));
            } else {
                request.setFileToSign(this.fileToSign.uploadOrReference(this.client));
            }
        }
        if (this.cmsToCoSign != null) {
            request.setCmsToCoSign(this.cmsToCoSign.uploadOrReference(this.client));
        }
        return this.client.getRestClient().post("Api/v3/CadesSignatures", request, CadesSignaturePostResponse.class);
    }

    private CadesSignaturePostResponse startCommonV2() throws RestException, IOException {
        if (this.fileToSign == null && this.cmsToCoSign == null) {
            throw new RuntimeException("The content to sign was not set and no CMS to be co-signed was given");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        CadesSignaturePostRequestV2 request = new CadesSignaturePostRequestV2();
        if (this.certificateBase64 != null) {
            request.setCertificate(Util.decodeBase64(this.certificateBase64));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setCallbackArgument(this.callbackArgument);
        request.setEncapsulateContent(this.encapsulateContent);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        if (this.fileToSign != null) {
            if (!this.encapsulateContent.booleanValue()) {
                request.setDataHashes(this.fileToSign.computeDataHashes(this.digestAlgorithmsForDetachedSignature));
            } else {
                request.setContentToSign(Util.decodeBase64(this.fileToSign.getContentBase64()));
            }
        }
        if (this.cmsToCoSign != null) {
            request.setCmsToCoSign(Util.decodeBase64(this.cmsToCoSign.getContentBase64()));
        }
        return this.client.getRestClient().post("Api/v2/CadesSignatures", request, CadesSignaturePostResponse.class);
    }

    private CadesSignaturePostResponse startCommonV1() throws RestException, IOException {
        if (this.fileToSign == null && this.cmsToCoSign == null) {
            throw new RuntimeException("The content to sign was not set and no CMS to be co-signed was given");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        CadesSignaturePostRequestV1 request = new CadesSignaturePostRequestV1();
        if (this.certificateBase64 != null) {
            request.setCertificate(Util.decodeBase64(this.certificateBase64));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setCallbackArgument(this.callbackArgument);
        request.setEncapsulateContent(this.encapsulateContent);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        if (this.fileToSign != null) {
            request.setContentToSign(Util.decodeBase64(this.fileToSign.getContentBase64()));
        }
        if (this.cmsToCoSign != null) {
            request.setCmsToCoSign(Util.decodeBase64(this.cmsToCoSign.getContentBase64()));
        }
        return this.client.getRestClient().post("Api/CadesSignatures", request, CadesSignaturePostResponse.class);
    }
}

