/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.CertificateExplorerResult;
import com.lacunasoftware.restpki.OpenCertificateRequest;
import com.lacunasoftware.restpki.OpenCertificateResponse;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SecurityContext;
import com.lacunasoftware.restpki.Util;
import java.util.UUID;

public class CertificateExplorer {
    private RestPkiClient client;
    private byte[] certificate;
    private String securityContextId;
    private boolean validate;

    public CertificateExplorer(RestPkiClient client) {
        this.client = client;
    }

    public byte[] getCertificate() {
        return this.certificate;
    }

    public void setCertificateRaw(byte[] certificateRaw) {
        this.certificate = certificateRaw;
    }

    public void setCertificateBase64(String certificateBase64) {
        this.certificate = Util.decodeBase64(certificateBase64);
    }

    public void setCertificate(String certificateBase64) {
        this.setCertificateBase64(certificateBase64);
    }

    public String getSecurityContextId() {
        return this.securityContextId;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContextId = securityContext.getId();
    }

    public void setSecurityContextId(String securityContextId) {
        this.securityContextId = securityContextId;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public CertificateExplorerResult open() throws RestException {
        if (this.certificate == null) {
            throw new RuntimeException("The certificate file was not set");
        }
        if (this.validate && this.securityContextId == null) {
            throw new RuntimeException("The security context id is required to validate certificate");
        }
        OpenCertificateRequest request = this.fillRequest(new OpenCertificateRequest());
        OpenCertificateResponse response = this.client.getRestClient().post("Api/Certificates/Open", request, OpenCertificateResponse.class);
        return new CertificateExplorerResult(response);
    }

    private OpenCertificateRequest fillRequest(OpenCertificateRequest request) {
        request.setCertificate(this.certificate);
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setValidate(this.validate);
        return request;
    }
}

