/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.DigestAlgorithm;
import com.lacunasoftware.restpki.Util;

public class ClientSideSignatureInstructions {
    private String token;
    private String toSignData;
    private String toSignHash;
    private String digestAlgorithmOid;

    public ClientSideSignatureInstructions(String token, String toSignData, String toSignHash, String digestAlgorithmOid) {
        this.token = token;
        this.toSignData = toSignData;
        this.toSignHash = toSignHash;
        this.digestAlgorithmOid = digestAlgorithmOid;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public byte[] getToSignDataRaw() {
        return Util.decodeBase64(this.getToSignData());
    }

    public String getToSignDataBase64() {
        return this.toSignData;
    }

    @Deprecated
    public String getToSignData() {
        return this.getToSignDataBase64();
    }

    public void setToSignData(String toSignData) {
        this.toSignData = toSignData;
    }

    public void setToSignDataRaw(byte[] toSignData) {
        this.toSignData = Util.encodeBase64(toSignData);
    }

    public byte[] getToSignHashRaw() {
        return Util.decodeBase64(this.getToSignHashBase64());
    }

    public String getToSignHashBase64() {
        return this.toSignHash;
    }

    public String getToSignHash() {
        return this.toSignHash;
    }

    public void setToSignHash(String toSignHash) {
        this.toSignHash = toSignHash;
    }

    public void setToSignHash(byte[] toSignHash) {
        this.toSignHash = Util.encodeBase64(toSignHash);
    }

    public String getDigestAlgorithmOid() {
        return this.digestAlgorithmOid;
    }

    public void setDigestAlgorithmOid(String digestAlgorithmOid) {
        this.digestAlgorithmOid = digestAlgorithmOid;
    }

    public String getSignatureAlgorithm() {
        switch (this.digestAlgorithmOid) {
            case "1.2.840.113549.2.5": {
                return "MD5withRSA";
            }
            case "1.3.14.3.2.26": {
                return "SHA1withRSA";
            }
            case "2.16.840.1.101.3.4.2.1": {
                return "SHA256withRSA";
            }
            case "2.16.840.1.101.3.4.2.2": {
                return "SHA384withRSA";
            }
            case "2.16.840.1.101.3.4.2.3": {
                return "SHA512withRSA";
            }
        }
        return null;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        if (this.digestAlgorithmOid == null) {
            return null;
        }
        switch (this.digestAlgorithmOid) {
            case "1.2.840.113549.2.5": {
                return DigestAlgorithm.MD5;
            }
            case "1.3.14.3.2.26": {
                return DigestAlgorithm.SHA1;
            }
            case "2.16.840.1.101.3.4.2.1": {
                return DigestAlgorithm.SHA256;
            }
            case "2.16.840.1.101.3.4.2.2": {
                return DigestAlgorithm.SHA384;
            }
            case "2.16.840.1.101.3.4.2.3": {
                return DigestAlgorithm.SHA512;
            }
        }
        return null;
    }

    public byte[] getEncodedDigestInfo() {
        switch (this.digestAlgorithmOid) {
            case "1.2.840.113549.2.5": {
                return new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};
            }
            case "1.3.14.3.2.26": {
                return new byte[]{48, 33, 48, 9, 6, 5, 43, 14, 3, 2, 26, 5, 0, 4, 20};
            }
            case "2.16.840.1.101.3.4.2.1": {
                return new byte[]{48, 49, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 1, 5, 0, 4, 32};
            }
            case "2.16.840.1.101.3.4.2.2": {
                return new byte[]{48, 65, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 2, 5, 0, 4, 48};
            }
            case "2.16.840.1.101.3.4.2.3": {
                return new byte[]{48, 81, 48, 13, 6, 9, 96, -122, 72, 1, 101, 3, 4, 2, 3, 5, 0, 4, 64};
            }
        }
        return null;
    }
}

