/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.ClientSideSignatureInstructions;
import com.lacunasoftware.restpki.DetachedResourceXmlSignatureRequest;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.XmlSignaturePostResponse;
import com.lacunasoftware.restpki.XmlSignatureStarter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;

public class DetachedResourceXmlSignatureStarter
extends XmlSignatureStarter {
    private String resourceUri;
    private byte[] resourceContent;

    public DetachedResourceXmlSignatureStarter(RestPkiClient client) {
        super(client);
    }

    public void setToSignDetachedResource(byte[] resourceContent, String resourceUri) {
        this.resourceContent = resourceContent;
        this.resourceUri = resourceUri;
    }

    public void setToSignDetachedResource(String resourcePath, String resourceUri) throws IOException {
        this.setToSignDetachedResource(Paths.get(resourcePath, new String[0]), resourceUri);
    }

    public void setToSignDetachedResource(Path resourcePath, String resourceUri) throws IOException {
        this.setToSignDetachedResource(Files.readAllBytes(resourcePath), resourceUri);
    }

    @Override
    public ClientSideSignatureInstructions start() throws RestException {
        if (this.certificate == null) {
            throw new RuntimeException("The certificate was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        if (this.resourceContent == null || this.resourceContent.length == 0) {
            throw new RuntimeException("The to sign resource was not set or is empty");
        }
        DetachedResourceXmlSignatureRequest request = new DetachedResourceXmlSignatureRequest();
        request.setXml(this.xml);
        request.setCallbackArgument(this.callbackArgument);
        if (this.certificate != null) {
            request.setCertificate(Util.decodeBase64(this.certificate));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        request.setSignatureElementLocation(this.signatureElementLocation);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setDetachedResourceToSignContent(this.resourceContent);
        request.setDetachedResourceReferenceUri(this.resourceUri);
        XmlSignaturePostResponse response = this.client.getRestClient().post("Api/XmlSignatures/DetachedResourceXmlSignature", request, XmlSignaturePostResponse.class);
        if (response.getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        ClientSideSignatureInstructions signatureInstructions = new ClientSideSignatureInstructions(response.getToken(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
        this.done = true;
        return signatureInstructions;
    }

    @Override
    public String startWithWebPki() throws RestException {
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        if (this.resourceContent == null || this.resourceContent.length == 0) {
            throw new RuntimeException("The to sign resource was not set or is empty");
        }
        DetachedResourceXmlSignatureRequest request = new DetachedResourceXmlSignatureRequest();
        request.setXml(this.xml);
        request.setCallbackArgument(this.callbackArgument);
        if (this.certificate != null) {
            request.setCertificate(Util.decodeBase64(this.certificate));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        if (this.securityContextId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        request.setSignatureElementLocation(this.signatureElementLocation);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setDetachedResourceToSignContent(this.resourceContent);
        request.setDetachedResourceReferenceUri(this.resourceUri);
        XmlSignaturePostResponse response = this.client.getRestClient().post("Api/XmlSignatures/DetachedResourceXmlSignature", request, XmlSignaturePostResponse.class);
        if (response.getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        this.done = true;
        return response.getToken();
    }
}

