/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
class EventsRequest {
    @JsonProperty(value="startDate")
    private Date startDate = null;
    @JsonProperty(value="endDate")
    private Date endDate = null;
    @JsonProperty(value="operations")
    private List<OperationsEnum> operations = null;
    @JsonProperty(value="success")
    private Boolean success = null;

    EventsRequest() {
    }

    public EventsRequest startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(value="")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public EventsRequest endDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="")
    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public EventsRequest operations(List<OperationsEnum> operations) {
        this.operations = operations;
        return this;
    }

    public EventsRequest addOperationsItem(OperationsEnum operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<OperationsEnum>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<OperationsEnum> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationsEnum> operations) {
        this.operations = operations;
    }

    public EventsRequest success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventsRequest eventsRequest = (EventsRequest)o;
        return Objects.equals(this.startDate, eventsRequest.startDate) && Objects.equals(this.endDate, eventsRequest.endDate) && Objects.equals(this.operations, eventsRequest.operations) && Objects.equals(this.success, eventsRequest.success);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.operations, this.success);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventsRequest {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationsEnum {
        ACCESSTOKENGENERATED("AccessTokenGenerated"),
        ACCESSTOKENSREVOKED("AccessTokensRevoked"),
        CERTAUTHSTARTED("CertAuthStarted"),
        CERTAUTHCOMPLETED("CertAuthCompleted"),
        PADESSIGNATURESTARTED("PadesSignatureStarted"),
        PADESSIGNATURECOMPLETED("PadesSignatureCompleted"),
        CADESSIGNATURESTARTED("CadesSignatureStarted"),
        CADESSIGNATURECOMPLETED("CadesSignatureCompleted"),
        XMLSIGNATURESTARTED("XmlSignatureStarted"),
        XMLSIGNATURECOMPLETED("XmlSignatureCompleted"),
        OPENSIGNATURE("OpenSignature"),
        ISSUETIMESTAMP("IssueTimestamp"),
        ADDPDFMARKS("AddPdfMarks"),
        GETPENDINGSIGNATURE("GetPendingSignature"),
        SETPENDINGSIGNATURE("SetPendingSignature");

        private String value;

        private OperationsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationsEnum fromValue(String text) {
            for (OperationsEnum b : OperationsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

