/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.BlobReference;
import com.lacunasoftware.restpki.DigestAlgorithm;
import com.lacunasoftware.restpki.DigestAlgorithmAndValueModel;
import com.lacunasoftware.restpki.FileModel;
import com.lacunasoftware.restpki.FileResult;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.util.ArrayList;
import java.util.List;

class FileRef {
    private InputStream stream;
    private Path path;
    private String blobToken;
    private String contentBase64;

    private FileRef() {
    }

    static FileRef fromStream(InputStream stream) {
        FileRef reference = new FileRef();
        reference.stream = stream;
        return reference;
    }

    static FileRef fromFile(String path) {
        return FileRef.fromFile(Paths.get(path, new String[0]));
    }

    static FileRef fromFile(Path path) {
        FileRef reference = new FileRef();
        reference.path = path;
        return reference;
    }

    static FileRef fromContent(byte[] contentRaw) {
        FileRef reference = new FileRef();
        reference.contentBase64 = Util.encodeBase64(contentRaw);
        return reference;
    }

    static FileRef fromContent(String contentBase64) {
        FileRef reference = new FileRef();
        reference.contentBase64 = contentBase64;
        return reference;
    }

    static FileRef fromResult(FileResult result) {
        if (result.file.getBlobToken() != null) {
            FileRef reference = new FileRef();
            reference.blobToken = result.file.getBlobToken();
            return reference;
        }
        return FileRef.fromContent(result.file.getContent());
    }

    static FileRef fromBlob(BlobReference blob) {
        FileRef reference = new FileRef();
        reference.blobToken = blob.getToken();
        return reference;
    }

    FileModel uploadOrReference(RestPkiClient client) throws RestException, IOException {
        if (this.blobToken != null) {
            FileModel file = new FileModel();
            file.setBlobToken(this.blobToken);
            return file;
        }
        if (this.contentBase64 != null && Util.decodeBase64(this.contentBase64).length < client.getMultipartUploadThreshold()) {
            FileModel file = new FileModel();
            file.setContent(Util.decodeBase64(this.contentBase64));
            return file;
        }
        InputStream s = this.openOrUseExistingStream();
        if (s.available() < client.getMultipartUploadThreshold()) {
            FileModel file = new FileModel();
            file.setContent(Util.readStream(s));
            return file;
        }
        Object uploadResult = client.uploadOrRead(s);
        FileModel file = new FileModel();
        if (uploadResult instanceof String) {
            this.blobToken = (String)uploadResult;
            file.setBlobToken(this.blobToken);
        } else {
            file.setContent((byte[])uploadResult);
        }
        return file;
    }

    byte[] getContent() throws IOException {
        return this.getContentRaw();
    }

    byte[] getContentRaw() throws IOException {
        if (this.contentBase64 != null) {
            return Util.decodeBase64(this.contentBase64);
        }
        InputStream s = this.openOrUseExistingStream();
        return Util.readStream(s);
    }

    String getContentBase64() throws IOException {
        if (this.contentBase64 != null) {
            return this.contentBase64;
        }
        InputStream s = this.openOrUseExistingStream();
        return Util.encodeBase64(Util.readStream(s));
    }

    void setContent(byte[] content) {
        this.contentBase64 = Util.encodeBase64(content);
    }

    void setContentBase64(String contentBase64) {
        this.contentBase64 = contentBase64;
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setBlobToken(String blobToken) {
        this.blobToken = blobToken;
    }

    List<DigestAlgorithmAndValueModel> computeDataHashes(List<DigestAlgorithm> algorithms) throws IOException {
        ArrayList<DigestInputStream> digestStreams = new ArrayList<DigestInputStream>();
        InputStream outermostStream = this.openOrUseExistingStream();
        for (DigestAlgorithm digestAlg : algorithms) {
            DigestInputStream digestStream = new DigestInputStream(outermostStream, digestAlg.getSpi());
            digestStreams.add(digestStream);
            outermostStream = digestStream;
        }
        byte[] buffer = new byte[0x400000];
        while (outermostStream.read(buffer) != -1) {
        }
        ArrayList<DigestAlgorithmAndValueModel> dataHashes = new ArrayList<DigestAlgorithmAndValueModel>();
        for (int i = 0; i < algorithms.size(); ++i) {
            DigestAlgorithm digestAlg = algorithms.get(i);
            DigestInputStream digestStream = (DigestInputStream)digestStreams.get(i);
            byte[] digestValue = digestStream.getMessageDigest().digest();
            DigestAlgorithmAndValueModel dataHash = new DigestAlgorithmAndValueModel();
            dataHash.setAlgorithm(digestAlg.getDigestAlgorithmAndValueModelEnum());
            dataHash.setValue(digestValue);
            dataHashes.add(dataHash);
        }
        return dataHashes;
    }

    private InputStream openOrUseExistingStream() throws IOException {
        if (this.stream != null) {
            return this.stream;
        }
        if (this.contentBase64 != null) {
            return new ByteArrayInputStream(this.getContent());
        }
        if (this.path != null) {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
        throw new RuntimeException();
    }
}

