/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.FileModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.Util;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;

public class FileResult {
    FileModel file;
    private RestPkiClient client;

    FileResult(RestPkiClient client, FileModel file) {
        this.client = client;
        this.file = file;
    }

    public InputStream openRead() throws RestException {
        if (this.file.getContent() != null) {
            return new ByteArrayInputStream(this.file.getContent());
        }
        return this.client.getRestClient().getStream(this.file.getUrl());
    }

    public void writeTo(OutputStream outStream) throws RestException, IOException {
        int nRead;
        byte[] buffer = new byte[4096];
        InputStream inStream = this.openRead();
        while ((nRead = inStream.read(buffer)) != -1) {
            outStream.write(buffer, 0, nRead);
        }
        inStream.close();
    }

    public void writeToFile(Path path) throws RestException, IOException {
        FileOutputStream outStream = new FileOutputStream(path.toString());
        this.writeTo(outStream);
        outStream.close();
    }

    public void writeToFile(String path) throws RestException, IOException {
        FileOutputStream outStream = new FileOutputStream(path);
        this.writeTo(outStream);
        outStream.close();
    }

    public byte[] getContent() throws RestException, IOException {
        InputStream inStream = this.openRead();
        byte[] content = Util.readStream(inStream);
        inStream.close();
        return content;
    }

    public FileModel getFile() {
        return this.file;
    }

    public void setFile(FileModel file) {
        this.file = file;
    }

    public RestPkiClient getClient() {
        return this.client;
    }

    public void setClient(RestPkiClient client) {
        this.client = client;
    }
}

