/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.ClientSideSignatureInstructions;
import com.lacunasoftware.restpki.FullXmlSignaturePostRequest;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.XmlSignaturePostResponse;
import com.lacunasoftware.restpki.XmlSignatureStarter;
import java.util.UUID;

public class FullXmlSignatureStarter
extends XmlSignatureStarter {
    public FullXmlSignatureStarter(RestPkiClient client) {
        super(client);
    }

    @Override
    public ClientSideSignatureInstructions start() throws RestException {
        if (this.xml == null) {
            throw new RuntimeException("The XML to sign was not set");
        }
        if (this.certificate == null) {
            throw new RuntimeException("The certificate was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        FullXmlSignaturePostRequest request = new FullXmlSignaturePostRequest();
        request.setXml(this.xml);
        request.setCallbackArgument(this.callbackArgument);
        if (this.certificate != null) {
            request.setCertificate(Util.decodeBase64(this.certificate));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        request.setSignatureElementLocation(this.signatureElementLocation);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        XmlSignaturePostResponse response = this.client.getRestClient().post("Api/XmlSignatures/FullXmlSignature", request, XmlSignaturePostResponse.class);
        if (response.getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        ClientSideSignatureInstructions signatureInstructions = new ClientSideSignatureInstructions(response.getToken(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
        this.done = true;
        return signatureInstructions;
    }

    @Override
    public String startWithWebPki() throws RestException {
        if (this.xml == null) {
            throw new RuntimeException("The XML to sign was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        FullXmlSignaturePostRequest request = new FullXmlSignaturePostRequest();
        request.setXml(this.xml);
        request.setCallbackArgument(this.callbackArgument);
        if (this.certificate != null) {
            request.setCertificate(Util.decodeBase64(this.certificate));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        request.setSignatureElementLocation(this.signatureElementLocation);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        XmlSignaturePostResponse response = this.client.getRestClient().post("Api/XmlSignatures/FullXmlSignature", request, XmlSignaturePostResponse.class);
        if (response.getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        this.done = true;
        return response.getToken();
    }
}

