/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.ClientSideSignatureInstructions;
import com.lacunasoftware.restpki.OnlineResourceXmlSignatureRequest;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.XmlSignaturePostResponse;
import com.lacunasoftware.restpki.XmlSignatureStarter;
import java.util.UUID;

public class OnlineResourceXmlSignatureStarter
extends XmlSignatureStarter {
    private String uri;

    public OnlineResourceXmlSignatureStarter(RestPkiClient client) {
        super(client);
    }

    @Deprecated
    public void SetToSignResourceUri(String uri) {
        this.uri = uri;
    }

    public void setToSignResourceUri(String uri) {
        this.uri = uri;
    }

    @Override
    public ClientSideSignatureInstructions start() throws RestException {
        if (this.certificate == null) {
            throw new RuntimeException("The certificate was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        if (this.uri == null || this.uri.equals("")) {
            throw new RuntimeException("The online resource URI to sign was not set or is empty");
        }
        OnlineResourceXmlSignatureRequest request = new OnlineResourceXmlSignatureRequest();
        request.setXml(this.xml);
        request.setCallbackArgument(this.callbackArgument);
        if (this.certificate != null) {
            request.setCertificate(Util.decodeBase64(this.certificate));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        request.setSignatureElementLocation(this.signatureElementLocation);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setResourceToSignUri(this.uri);
        XmlSignaturePostResponse response = this.client.getRestClient().post("Api/XmlSignatures/OnlineResourceXmlSignature", request, XmlSignaturePostResponse.class);
        if (response.getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        ClientSideSignatureInstructions signatureInstructions = new ClientSideSignatureInstructions(response.getToken(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
        this.done = true;
        return signatureInstructions;
    }

    @Override
    public String startWithWebPki() throws RestException {
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        if (this.uri == null || this.uri.equals("")) {
            throw new RuntimeException("The online resource URI to sign was not set or is empty");
        }
        OnlineResourceXmlSignatureRequest request = new OnlineResourceXmlSignatureRequest();
        request.setXml(this.xml);
        request.setCallbackArgument(this.callbackArgument);
        if (this.certificate != null) {
            request.setCertificate(Util.decodeBase64(this.certificate));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        request.setSignatureElementLocation(this.signatureElementLocation);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setResourceToSignUri(this.uri);
        XmlSignaturePostResponse response = this.client.getRestClient().post("Api/XmlSignatures/OnlineResourceXmlSignature", request, XmlSignaturePostResponse.class);
        if (response.getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        this.done = true;
        return response.getToken();
    }
}

