/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.CertificateModel;
import com.lacunasoftware.restpki.Name;
import com.lacunasoftware.restpki.PkiBrazilCertificateFields;
import com.lacunasoftware.restpki.PkiItalyCertificateFields;
import com.lacunasoftware.restpki.Util;
import java.math.BigInteger;
import java.util.Date;

public class PKCertificate {
    private Name subjectName;
    private String emailAddress;
    private Name issuerName;
    private BigInteger serialNumber;
    private Date validityStart;
    private Date validityEnd;
    private PkiBrazilCertificateFields pkiBrazil;
    private PkiItalyCertificateFields pkiItaly;
    private PKCertificate issuer;
    private byte[] binaryThumbprintSHA256;
    private String thumbprint;

    PKCertificate(CertificateModel model) {
        this.subjectName = new Name(model.getSubjectName());
        this.emailAddress = model.getEmailAddress();
        this.issuerName = new Name(model.getIssuerName());
        this.serialNumber = new BigInteger(model.getSerialNumber());
        this.pkiBrazil = new PkiBrazilCertificateFields(model.getPkiBrazil());
        this.pkiItaly = new PkiItalyCertificateFields(model.getPkiItaly());
        if (model.getIssuer() != null) {
            this.issuer = new PKCertificate(model.getIssuer());
        }
        this.binaryThumbprintSHA256 = model.getBinaryThumbprintSHA256();
        this.thumbprint = model.getThumbprint();
        if (model.getValidityStart() != null) {
            this.validityStart = Util.parseApiDate(model.getValidityStart());
        }
        if (model.getValidityEnd() != null) {
            this.validityEnd = Util.parseApiDate(model.getValidityEnd());
        }
    }

    public Name getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(Name subjectName) {
        this.subjectName = subjectName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Name getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(Name issuerName) {
        this.issuerName = issuerName;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Date getValidityStart() {
        return this.validityStart;
    }

    public void setValidityStart(Date validityStart) {
        this.validityStart = validityStart;
    }

    public Date getValidityEnd() {
        return this.validityEnd;
    }

    public void setValidityEnd(Date validityEnd) {
        this.validityEnd = validityEnd;
    }

    public PkiBrazilCertificateFields getPkiBrazil() {
        return this.pkiBrazil;
    }

    public void setPkiBrazil(PkiBrazilCertificateFields pkiBrazil) {
        this.pkiBrazil = pkiBrazil;
    }

    public PkiItalyCertificateFields getPkiItaly() {
        return this.pkiItaly;
    }

    public void setPkiItaly(PkiItalyCertificateFields pkiItaly) {
        this.pkiItaly = pkiItaly;
    }

    public PKCertificate getIssuer() {
        return this.issuer;
    }

    public void setIssuer(PKCertificate issuer) {
        this.issuer = issuer;
    }

    public byte[] getBinaryThumbprintSHA256() {
        return this.binaryThumbprintSHA256;
    }

    public void setBinaryThumbprintSHA256(byte[] binaryThumbprintSHA256) {
        this.binaryThumbprintSHA256 = binaryThumbprintSHA256;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }
}

