/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.PadesPageOptimizationModel;
import com.lacunasoftware.restpki.PadesPageOrientation;
import com.lacunasoftware.restpki.PadesPaperSize;
import com.lacunasoftware.restpki.PadesSize;

public class PadesPageOptimization {
    private PadesPaperSize paperSize;
    private PadesSize customPaperSize;
    private PadesPageOrientation pageOrientation = PadesPageOrientation.Auto;

    public PadesPageOptimization() {
    }

    public PadesPageOptimization(PadesPaperSize paperSize) {
        this();
        this.paperSize = paperSize;
    }

    public PadesPageOptimization(PadesSize customPaperSize) {
        this();
        this.paperSize = PadesPaperSize.Custom;
        this.customPaperSize = customPaperSize;
    }

    public PadesPaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PadesPaperSize paperSize) {
        this.paperSize = paperSize;
    }

    public PadesSize getCustomPaperSize() {
        return this.customPaperSize;
    }

    public void setCustomPaperSize(PadesSize customPaperSize) {
        this.customPaperSize = customPaperSize;
        this.paperSize = PadesPaperSize.Custom;
    }

    public PadesPageOrientation getPageOrientation() {
        return this.pageOrientation;
    }

    public void setPageOrientation(PadesPageOrientation pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    public PadesPageOptimizationModel toModel() {
        PadesPageOptimizationModel model = new PadesPageOptimizationModel();
        if (this.paperSize != null) {
            model.setPaperSize(PadesPageOptimizationModel.PaperSizeEnum.fromValue(this.paperSize.toString()));
        }
        if (this.paperSize == PadesPaperSize.Custom) {
            if (this.customPaperSize != null) {
                model.setCustomPaperSize(this.customPaperSize.toModel());
            } else {
                throw new IllegalStateException("The paperSize is set to Custom but no customPaperSize was set");
            }
        }
        if (this.pageOrientation != null) {
            model.setPageOrientation(PadesPageOptimizationModel.PageOrientationEnum.fromValue(this.pageOrientation.toString()));
        }
        return model;
    }

    static PadesPageOptimization createFromModel(PadesPageOptimizationModel model) {
        PadesPageOptimization entity = new PadesPageOptimization();
        if (model.getPaperSize() != null) {
            entity.paperSize = PadesPaperSize.valueOf(model.getPaperSize().toString());
        }
        if (model.getCustomPaperSize() != null) {
            entity.customPaperSize = new PadesSize(model.getCustomPaperSize().getWidth(), model.getCustomPaperSize().getWidth());
        }
        if (model.getPageOrientation() != null) {
            entity.pageOrientation = PadesPageOrientation.valueOf(model.getPageOrientation().toString());
        }
        return entity;
    }
}

