/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.PadesSignaturePostSignedBytesRequest;
import com.lacunasoftware.restpki.PadesSignaturePostSignedBytesResponse;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureFinisher;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PadesSignatureFinisher
extends SignatureFinisher {
    private byte[] signedPdf;

    public PadesSignatureFinisher(RestPkiClient client) {
        super(client);
    }

    @Override
    public byte[] finish() throws RestException {
        PadesSignaturePostSignedBytesResponse response;
        if (this.token == null) {
            throw new RuntimeException("The token was not set");
        }
        if (this.signature == null) {
            String actionUrl = String.format("Api/PadesSignatures/%s/Finalize", this.token);
            response = this.client.getRestClient().post(actionUrl, null, PadesSignaturePostSignedBytesResponse.class);
        } else {
            PadesSignaturePostSignedBytesRequest request = new PadesSignaturePostSignedBytesRequest();
            request.setSignature(Util.decodeBase64(this.signature));
            String actionUrl = String.format("Api/PadesSignatures/%s/SignedBytes", this.token);
            response = this.client.getRestClient().post(actionUrl, request, PadesSignaturePostSignedBytesResponse.class);
        }
        this.signedPdf = (byte[])new ObjectMapper().convertValue((Object)response.getSignedPdf(), byte[].class);
        this.callbackArgument = response.getCallbackArgument();
        this.certificateInfo = new PKCertificate(response.getCertificate());
        this.done = true;
        return this.signedPdf;
    }

    public byte[] getSignedPdf() {
        if (!this.done) {
            throw new RuntimeException("The getSignedPdf() method can only be called after calling the finish() method");
        }
        return this.signedPdf;
    }

    public void writeSignedPdfToFile(String path) throws IOException {
        this.writeSignedPdfToFile(Paths.get(path, new String[0]));
    }

    public void writeSignedPdfToFile(Path path) throws IOException {
        if (!this.done) {
            throw new RuntimeException("The writeSignedPdfToFile() method can only be called after calling the finish() method");
        }
        Files.write(path, this.signedPdf, new OpenOption[0]);
    }
}

