/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.restpki.ClientSideSignatureInstructions;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.PadesMeasurementUnits;
import com.lacunasoftware.restpki.PadesPageOptimization;
import com.lacunasoftware.restpki.PadesSignaturePostRequest;
import com.lacunasoftware.restpki.PadesSignaturePostResponse;
import com.lacunasoftware.restpki.PadesVisualRepresentation;
import com.lacunasoftware.restpki.PdfMark;
import com.lacunasoftware.restpki.PdfMarkModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureStarter;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class PadesSignatureStarter
extends SignatureStarter {
    private byte[] pdfContent;
    private PadesVisualRepresentation visualRepresentation;
    private List<PdfMark> pdfMarks = new ArrayList<PdfMark>();
    private boolean bypassMarksIfSigned = true;
    private PadesPageOptimization pageOptimization;
    private PadesMeasurementUnits measurementUnits = PadesMeasurementUnits.Centimeters;

    public PadesSignatureStarter(RestPkiClient client) {
        super(client);
    }

    public void setPdfToSign(InputStream stream) throws IOException {
        this.pdfContent = Util.readStream(stream);
    }

    public void setPdfToSign(byte[] content) {
        this.pdfContent = content;
    }

    public void setPdfToSign(String path) throws IOException {
        this.setPdfToSign(Paths.get(path, new String[0]));
    }

    public void setPdfToSign(Path path) throws IOException {
        this.pdfContent = Files.readAllBytes(path);
    }

    public void setBypassMarksIfSigned(boolean bypassMarksIfSigned) {
        this.bypassMarksIfSigned = bypassMarksIfSigned;
    }

    public void setPageOptimization(PadesPageOptimization pageOptimization) {
        this.pageOptimization = pageOptimization;
    }

    public void setMeasurementUnits(PadesMeasurementUnits measurementUnits) {
        this.measurementUnits = measurementUnits;
    }

    public void setVisualRepresentation(PadesVisualRepresentation visualRepresentation) {
        this.visualRepresentation = visualRepresentation;
    }

    public void setPdfMarks(List<PdfMark> pdfMarks) {
        this.pdfMarks = pdfMarks;
    }

    public void addPdfMark(PdfMark pdfMark) {
        if (this.pdfMarks == null) {
            this.setPdfMarks(new ArrayList<PdfMark>());
        }
        this.pdfMarks.add(pdfMark);
    }

    @Override
    public ClientSideSignatureInstructions start() throws RestException {
        PadesSignaturePostResponse response;
        List<PdfMarkModel> pdfMarkModels;
        if (this.pdfContent == null) {
            throw new RuntimeException("The pdf to sign was not set");
        }
        if (this.certificate == null) {
            throw new RuntimeException("The certificate was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        PadesSignaturePostRequest request = new PadesSignaturePostRequest();
        request.setPdfToSign((String)new ObjectMapper().convertValue((Object)this.pdfContent, String.class));
        request.setCertificate(this.certificate);
        request.setSignaturePolicyId(this.signaturePolicyId);
        request.setSecurityContextId(this.securityContextId);
        request.setCallbackArgument(this.callbackArgument);
        request.setBypassMarksIfSigned(this.bypassMarksIfSigned);
        if (this.visualRepresentation != null) {
            request.setVisualRepresentation(this.visualRepresentation.toModel());
        }
        if (this.measurementUnits != null) {
            request.setMeasurementUnits(PadesSignaturePostRequest.MeasurementUnitsEnum.valueOf(this.measurementUnits.toString()));
        }
        if (this.pageOptimization != null) {
            request.setPageOptimization(this.pageOptimization.toModel());
        }
        if ((pdfMarkModels = this.getPdfMarksModel()) != null) {
            request.setPdfMarks(pdfMarkModels);
        }
        if ((response = this.client.getRestClient().post("Api/PadesSignatures", request, PadesSignaturePostResponse.class)).getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        ClientSideSignatureInstructions signatureInstructions = new ClientSideSignatureInstructions(response.getToken(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
        this.done = true;
        return signatureInstructions;
    }

    @Override
    public String startWithWebPki() throws RestException {
        PadesSignaturePostResponse response;
        List<PdfMarkModel> pdfMarkModels;
        if (this.pdfContent == null) {
            throw new RuntimeException("The pdf to sign was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        PadesSignaturePostRequest request = new PadesSignaturePostRequest();
        request.setPdfToSign((String)new ObjectMapper().convertValue((Object)this.pdfContent, String.class));
        request.setCertificate(this.certificate);
        request.setSignaturePolicyId(this.signaturePolicyId);
        request.setSecurityContextId(this.securityContextId);
        request.setCallbackArgument(this.callbackArgument);
        request.setBypassMarksIfSigned(this.bypassMarksIfSigned);
        if (this.visualRepresentation != null) {
            request.setVisualRepresentation(this.visualRepresentation.toModel());
        }
        if (this.measurementUnits != null) {
            request.setMeasurementUnits(PadesSignaturePostRequest.MeasurementUnitsEnum.valueOf(this.measurementUnits.toString()));
        }
        if (this.pageOptimization != null) {
            request.setPageOptimization(this.pageOptimization.toModel());
        }
        if ((pdfMarkModels = this.getPdfMarksModel()) != null) {
            request.setPdfMarks(pdfMarkModels);
        }
        if ((response = this.client.getRestClient().post("Api/PadesSignatures", request, PadesSignaturePostResponse.class)).getCertificate() != null) {
            this.certificateInfo = new PKCertificate(response.getCertificate());
        }
        this.done = true;
        return response.getToken();
    }

    private List<PdfMarkModel> getPdfMarksModel() {
        if (this.pdfMarks == null || this.pdfMarks.size() == 0) {
            return null;
        }
        ArrayList<PdfMarkModel> pdfMarkModels = new ArrayList<PdfMarkModel>();
        for (PdfMark mark : this.pdfMarks) {
            pdfMarkModels.add(mark.toModel());
        }
        return pdfMarkModels;
    }
}

