/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.Apis;
import com.lacunasoftware.restpki.FileRef;
import com.lacunasoftware.restpki.FileResult;
import com.lacunasoftware.restpki.PadesMeasurementUnits;
import com.lacunasoftware.restpki.PadesPageOptimization;
import com.lacunasoftware.restpki.PadesSignaturePostRequestV1;
import com.lacunasoftware.restpki.PadesSignaturePostRequestV2;
import com.lacunasoftware.restpki.PadesSignaturePostResponse;
import com.lacunasoftware.restpki.PadesVisualRepresentation;
import com.lacunasoftware.restpki.PdfMark;
import com.lacunasoftware.restpki.PdfMarkModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureStartResult;
import com.lacunasoftware.restpki.SignatureStartWithWebPkiResult;
import com.lacunasoftware.restpki.SignatureStarter2;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PadesSignatureStarter2
extends SignatureStarter2 {
    private FileRef pdfToSign;
    private PadesVisualRepresentation visualRepresentation;
    private List<PdfMark> pdfMarks = new ArrayList<PdfMark>();
    private boolean bypassMarksIfSigned = true;
    private PadesPageOptimization pageOptimization;
    private PadesMeasurementUnits measurementUnits = PadesMeasurementUnits.Centimeters;

    public PadesSignatureStarter2(RestPkiClient client) {
        super(client);
    }

    public void setPdfToSign(InputStream stream) {
        this.pdfToSign = FileRef.fromStream(stream);
    }

    public void setPdfToSign(byte[] content) {
        this.pdfToSign = FileRef.fromContent(content);
    }

    public void setPdfToSign(String path) {
        this.setPdfToSign(Paths.get(path, new String[0]));
    }

    public void setPdfToSign(Path path) {
        this.pdfToSign = FileRef.fromFile(path);
    }

    public void setPdfToSign(FileResult fileResult) {
        this.pdfToSign = FileRef.fromResult(fileResult);
    }

    public void setBypassMarksIfSigned(boolean bypassMarksIfSigned) {
        this.bypassMarksIfSigned = bypassMarksIfSigned;
    }

    public void setPageOptimization(PadesPageOptimization pageOptimization) {
        this.pageOptimization = pageOptimization;
    }

    public void setMeasurementUnits(PadesMeasurementUnits measurementUnits) {
        this.measurementUnits = measurementUnits;
    }

    public void setVisualRepresentation(PadesVisualRepresentation visualRepresentation) {
        this.visualRepresentation = visualRepresentation;
    }

    public void setPdfMarks(List<PdfMark> pdfMarks) {
        this.pdfMarks = pdfMarks;
    }

    public void addPdfMark(PdfMark pdfMark) {
        if (this.pdfMarks == null) {
            this.setPdfMarks(new ArrayList<PdfMark>());
        }
        this.pdfMarks.add(pdfMark);
    }

    @Override
    public SignatureStartResult start() throws RestException, IOException {
        if (this.certificateBase64 == null) {
            throw new RuntimeException("The certificate was not set");
        }
        PadesSignaturePostResponse response = this.startCommon();
        return new SignatureStartResult(response.getToken(), response.getCertificate(), Util.encodeBase64(response.getToSignData()), Util.encodeBase64(response.getToSignHash()), response.getDigestAlgorithmOid());
    }

    @Override
    public SignatureStartWithWebPkiResult startWithWebPki() throws RestException, IOException {
        PadesSignaturePostResponse response = this.startCommon();
        return new SignatureStartWithWebPkiResult(response.getToken(), response.getCertificate());
    }

    private PadesSignaturePostResponse startCommon() throws RestException, IOException {
        if (this.pdfToSign == null) {
            throw new RuntimeException("The pdf to sign was not set");
        }
        if (this.signaturePolicyId == null) {
            throw new RuntimeException("The signature policy was not set");
        }
        int apiVersion = this.client.getApiVersion(Apis.StartPades);
        switch (apiVersion) {
            case 1: {
                return this.startCommonV1();
            }
        }
        return this.startCommonV2();
    }

    private PadesSignaturePostResponse startCommonV2() throws RestException, IOException {
        List<PdfMarkModel> pdfMarkModels;
        PadesSignaturePostRequestV2 request = new PadesSignaturePostRequestV2();
        if (this.certificateBase64 != null) {
            request.setCertificate(Util.decodeBase64(this.certificateBase64));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setCallbackArgument(this.callbackArgument);
        request.setBypassMarksIfSigned(this.bypassMarksIfSigned);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        if (this.visualRepresentation != null) {
            request.setVisualRepresentation(this.visualRepresentation.toModel());
        }
        if (this.measurementUnits != null) {
            request.setMeasurementUnits(PadesSignaturePostRequestV2.MeasurementUnitsEnum.fromValue(this.measurementUnits.toString()));
        }
        if (this.pageOptimization != null) {
            request.setPageOptimization(this.pageOptimization.toModel());
        }
        if ((pdfMarkModels = this.getPdfMarksModel()) != null) {
            request.setPdfMarks(pdfMarkModels);
        }
        request.setPdfToSign(this.pdfToSign.uploadOrReference(this.client));
        return this.client.getRestClient().post("Api/v2/PadesSignatures", request, PadesSignaturePostResponse.class);
    }

    private PadesSignaturePostResponse startCommonV1() throws RestException, IOException {
        List<PdfMarkModel> pdfMarkModels;
        PadesSignaturePostRequestV1 request = new PadesSignaturePostRequestV1();
        if (this.certificateBase64 != null) {
            request.setCertificate(Util.decodeBase64(this.certificateBase64));
        }
        if (this.signaturePolicyId != null) {
            request.setSignaturePolicyId(UUID.fromString(this.signaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setCallbackArgument(this.callbackArgument);
        request.setBypassMarksIfSigned(this.bypassMarksIfSigned);
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        if (this.visualRepresentation != null) {
            request.setVisualRepresentation(this.visualRepresentation.toModel());
        }
        if (this.measurementUnits != null) {
            request.setMeasurementUnits(PadesSignaturePostRequestV1.MeasurementUnitsEnum.fromValue(this.measurementUnits.toString()));
        }
        if (this.pageOptimization != null) {
            request.setPageOptimization(this.pageOptimization.toModel());
        }
        if ((pdfMarkModels = this.getPdfMarksModel()) != null) {
            request.setPdfMarks(pdfMarkModels);
        }
        request.setPdfToSign(Util.decodeBase64(this.pdfToSign.getContentBase64()));
        return this.client.getRestClient().post("Api/PadesSignatures", request, PadesSignaturePostResponse.class);
    }

    private List<PdfMarkModel> getPdfMarksModel() {
        if (this.pdfMarks == null || this.pdfMarks.size() == 0) {
            return null;
        }
        ArrayList<PdfMarkModel> pdfMarkModels = new ArrayList<PdfMarkModel>();
        for (PdfMark mark : this.pdfMarks) {
            pdfMarkModels.add(mark.toModel());
        }
        return pdfMarkModels;
    }
}

