/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.PadesTextHorizontalAlign;
import com.lacunasoftware.restpki.PadesVisualRectangle;
import com.lacunasoftware.restpki.PadesVisualTextModel;

public class PadesVisualText {
    private Double fontSize;
    private String text;
    private Boolean includeSigningTime;
    private PadesTextHorizontalAlign horizontalAlign = PadesTextHorizontalAlign.Left;
    private PadesVisualRectangle container;

    public PadesVisualText() {
    }

    public PadesVisualText(String text) {
        this();
        this.text = text;
    }

    public PadesVisualText(String text, boolean includeSigningTime) {
        this();
        this.text = text;
        this.includeSigningTime = includeSigningTime;
    }

    public PadesVisualText(String text, double fontSize) {
        this();
        this.text = text;
        this.fontSize = fontSize;
    }

    public PadesVisualText(String text, boolean includeSigningTime, double fontSize) {
        this();
        this.text = text;
        this.includeSigningTime = includeSigningTime;
        this.fontSize = fontSize;
    }

    public Double getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Double fontSize) {
        this.fontSize = fontSize;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Boolean getIncludeSigningTime() {
        return this.includeSigningTime;
    }

    public void setIncludeSigningTime(Boolean includeSigningTime) {
        this.includeSigningTime = includeSigningTime;
    }

    public PadesTextHorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(PadesTextHorizontalAlign horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public PadesVisualRectangle getContainer() {
        return this.container;
    }

    public void setContainer(PadesVisualRectangle container) {
        this.container = container;
    }

    public PadesVisualTextModel toModel() {
        PadesVisualTextModel model = new PadesVisualTextModel();
        model.setFontSize(this.fontSize);
        model.setText(this.text);
        model.setIncludeSigningTime(this.includeSigningTime);
        if (this.horizontalAlign != null) {
            model.setHorizontalAlign(PadesVisualTextModel.HorizontalAlignEnum.fromValue(this.horizontalAlign.toString()));
        }
        if (this.container != null) {
            model.setContainer(this.container.toModel());
        }
        return model;
    }
}

