/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.PadesVisualRectangle;
import com.lacunasoftware.restpki.PdfMarkElement;
import com.lacunasoftware.restpki.PdfMarkElementModel;
import com.lacunasoftware.restpki.PdfMarkModel;
import com.lacunasoftware.restpki.PdfMarkPageOptions;
import com.lacunasoftware.restpki.Util;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class PdfMark {
    private PadesVisualRectangle container;
    private double borderWidth;
    private Color borderColor;
    private Color backgroundColor;
    private List<PdfMarkElement> elements;
    private PdfMarkPageOptions pageOption = PdfMarkPageOptions.AllPages;
    private int pageOptionNumber;

    public PdfMark() {
        this.borderColor = Color.BLACK;
        this.backgroundColor = new Color(255, 255, 255, 0);
        this.elements = new ArrayList<PdfMarkElement>();
    }

    public PdfMarkModel toModel() {
        PdfMarkModel model = new PdfMarkModel();
        model.setContainer(this.container.toModel());
        model.setBackgroundColor(Util.convertColorToModel(this.backgroundColor));
        model.setBorderColor(Util.convertColorToModel(this.borderColor));
        model.setBorderWidth(this.borderWidth);
        model.setPageOption(PdfMarkModel.PageOptionEnum.fromValue(this.pageOption.toString()));
        model.setPageOptionNumber(this.pageOptionNumber);
        ArrayList<PdfMarkElementModel> elementsModels = new ArrayList<PdfMarkElementModel>();
        for (PdfMarkElement element : this.elements) {
            elementsModels.add(element.toModel());
        }
        model.setElements(elementsModels);
        return model;
    }

    public PdfMark onContainer(PadesVisualRectangle container) {
        this.container = container;
        return this;
    }

    public PdfMark withBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public PdfMark onAllPages() {
        this.pageOption = PdfMarkPageOptions.AllPages;
        return this;
    }

    public PdfMark onNewPage() {
        this.pageOption = PdfMarkPageOptions.NewPage;
        return this;
    }

    public PdfMark onSinglePage(int pageNumber) {
        this.pageOption = PdfMarkPageOptions.SinglePage;
        this.pageOptionNumber = pageNumber;
        return this;
    }

    public PdfMark onSinglePageFromEnd(int pageNumber) {
        this.pageOption = PdfMarkPageOptions.SinglePageFromEnd;
        this.pageOptionNumber = pageNumber;
        return this;
    }

    public PdfMark addElement(PdfMarkElement element) {
        this.elements.add(element);
        return this;
    }

    public PdfMark withBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public PdfMark withBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public PadesVisualRectangle getContainer() {
        return this.container;
    }

    public void setContainer(PadesVisualRectangle container) {
        this.container = container;
    }

    public double getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(double borderWidth) {
        this.borderWidth = borderWidth;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public List<PdfMarkElement> getElements() {
        return this.elements;
    }

    public void setElements(List<PdfMarkElement> elements) {
        this.elements = elements;
    }

    public PdfMarkPageOptions getPageOption() {
        return this.pageOption;
    }

    public void setPageOption(PdfMarkPageOptions pageOption) {
        this.pageOption = pageOption;
    }

    public int getPageOptionNumber() {
        return this.pageOptionNumber;
    }

    public void setPageOptionNumber(int pageOptionNumber) {
        this.pageOptionNumber = pageOptionNumber;
    }
}

