/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.PdfMarkImageModel;
import com.lacunasoftware.restpki.ResourceContentOrReference;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PdfMarkImage {
    private String url;
    private String content;
    private String mimeType;
    private int alpha = 255;

    public PdfMarkImage() {
    }

    public PdfMarkImage(byte[] imageContent, String mimeType) {
        this();
        this.content = Util.encodeBase64(imageContent);
        this.mimeType = mimeType;
    }

    public PdfMarkImage(String imageUrl, String mimeType) {
        this();
        this.url = imageUrl;
        this.mimeType = mimeType;
    }

    @Deprecated
    public void setContentFromFile(InputStream stream) throws IOException {
        this.setContent(stream);
    }

    public void setContent(InputStream stream) throws IOException {
        this.content = Util.encodeBase64(Util.readStream(stream));
    }

    @Deprecated
    public void setContentFromFile(byte[] content) {
        this.setContent(content);
    }

    public void setContent(byte[] content) {
        this.content = Util.encodeBase64(content);
    }

    @Deprecated
    public void setContentFromFile(String filePath) throws IOException {
        this.setContent(filePath);
    }

    public void setContent(String filePath) throws IOException {
        this.content = Util.encodeBase64(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    @Deprecated
    public void setContentFromFile(Path path) throws IOException {
        this.setContent(path);
    }

    public void setContent(Path path) throws IOException {
        this.content = Util.encodeBase64(Files.readAllBytes(path));
    }

    public PdfMarkImageModel toModel() {
        PdfMarkImageModel model = new PdfMarkImageModel();
        model.setOpacity((double)this.alpha / 2.55);
        if (this.content != null) {
            ResourceContentOrReference resource = new ResourceContentOrReference();
            resource.setContent(Util.decodeBase64(this.content));
            resource.setMimeType(this.mimeType);
            model.setResource(resource);
        } else if (this.url != null && this.url.length() > 0) {
            ResourceContentOrReference resource = new ResourceContentOrReference();
            resource.setUrl(this.url);
            resource.setMimeType(this.mimeType);
            model.setResource(resource);
        } else {
            throw new RuntimeException("The image content was not set, neither its URL");
        }
        return model;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContent() {
        return this.content;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

