/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.PadesVisualRectangle;
import com.lacunasoftware.restpki.PdfMarkElement;
import com.lacunasoftware.restpki.PdfMarkElementModel;
import com.lacunasoftware.restpki.PdfMarkElementType;

public class PdfMarkQRCodeElement
extends PdfMarkElement<PdfMarkQRCodeElement> {
    private String qrCodeData;
    private boolean drawQuietZones;

    public PdfMarkQRCodeElement() {
        super(PdfMarkElementType.QRCode);
    }

    public PdfMarkQRCodeElement(PadesVisualRectangle relativeContainer, String qrCodeData) {
        super(PdfMarkElementType.QRCode, relativeContainer);
        this.qrCodeData = qrCodeData;
    }

    @Override
    public PdfMarkElementModel toModel() {
        PdfMarkElementModel model = super.toModel();
        model.setQrCodeData(this.qrCodeData);
        model.setQrCodeDrawQuietZones(this.drawQuietZones);
        return model;
    }

    public PdfMarkQRCodeElement withQRCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
        return this;
    }

    public PdfMarkQRCodeElement drawQuietZones() {
        this.drawQuietZones = true;
        return this;
    }

    public String getQrCodeData() {
        return this.qrCodeData;
    }

    public void setQrCodeData(String qrCodeData) {
        this.qrCodeData = qrCodeData;
    }

    public boolean getDrawQuietZones() {
        return this.drawQuietZones;
    }

    public void setDrawQuietZones(boolean drawQuietZones) {
        this.drawQuietZones = drawQuietZones;
    }
}

