/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.Apis;
import com.lacunasoftware.restpki.BlobReference;
import com.lacunasoftware.restpki.FileRef;
import com.lacunasoftware.restpki.FileResult;
import com.lacunasoftware.restpki.PadesMeasurementUnits;
import com.lacunasoftware.restpki.PadesPageOptimization;
import com.lacunasoftware.restpki.PdfAddMarksRequest;
import com.lacunasoftware.restpki.PdfAddMarksResponse;
import com.lacunasoftware.restpki.PdfMark;
import com.lacunasoftware.restpki.PdfMarkModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class PdfMarker {
    private PadesMeasurementUnits measurementUnits;
    private PadesPageOptimization pageOptimization;
    private boolean abortIfSigned;
    private List<PdfMark> marks;
    private boolean forceBlobResult;
    private boolean preserveSignaturesVisualRepresentation = false;
    private RestPkiClient client;
    private FileRef file;

    public PdfMarker(RestPkiClient client) {
        this.client = client;
        this.marks = new ArrayList<PdfMark>();
        this.measurementUnits = PadesMeasurementUnits.Centimeters;
    }

    public void setFile(InputStream stream) {
        this.file = FileRef.fromStream(stream);
    }

    public void setFile(byte[] content) {
        this.file = FileRef.fromContent(content);
    }

    public void setFile(String path) {
        this.file = FileRef.fromFile(path);
    }

    public void setFile(Path path) {
        this.file = FileRef.fromFile(path);
    }

    public void setFile(FileResult fileResult) {
        this.file = FileRef.fromResult(fileResult);
    }

    public void setFile(BlobReference fileBlob) {
        this.file = FileRef.fromBlob(fileBlob);
    }

    public FileResult apply() throws IOException, RestException {
        int apiVersion = this.client.getApiVersion(Apis.AddPdfMarks);
        if (apiVersion < 1) {
            throw new RuntimeException("The PdfMarker class can only be used with Rest PKI 1.13 or later. Please contact technical support to update your Rest PKI.");
        }
        PdfAddMarksRequest request = new PdfAddMarksRequest();
        ArrayList<PdfMarkModel> markModels = new ArrayList<PdfMarkModel>();
        for (PdfMark mark : this.marks) {
            markModels.add(mark.toModel());
        }
        request.setMarks(markModels);
        request.setMeasurementUnits(PdfAddMarksRequest.MeasurementUnitsEnum.fromValue(this.measurementUnits.toString()));
        if (this.pageOptimization != null) {
            request.setPageOptimization(this.pageOptimization.toModel());
        }
        request.setForceBlobResult(this.forceBlobResult);
        request.setPreserveSignaturesVisualRepresentation(this.preserveSignaturesVisualRepresentation);
        request.setAbortIfSigned(this.abortIfSigned);
        request.setFile(this.file.uploadOrReference(this.client));
        PdfAddMarksResponse response = this.client.getRestClient().post("Api/Pdf/AddMarks", request, PdfAddMarksResponse.class);
        return new FileResult(this.client, response.getFile());
    }

    public PadesMeasurementUnits getMeasurementUnits() {
        return this.measurementUnits;
    }

    public void setMeasurementUnits(PadesMeasurementUnits measurementUnits) {
        this.measurementUnits = measurementUnits;
    }

    public PadesPageOptimization getPageOptimization() {
        return this.pageOptimization;
    }

    public void setPageOptimization(PadesPageOptimization pageOptimization) {
        this.pageOptimization = pageOptimization;
    }

    public boolean getAbortIfSigned() {
        return this.abortIfSigned;
    }

    public void setAbortIfSigned(boolean abortIfSigned) {
        this.abortIfSigned = abortIfSigned;
    }

    public List<PdfMark> getMarks() {
        return this.marks;
    }

    public void setMarks(List<PdfMark> marks) {
        this.marks = marks;
    }

    public void addMark(PdfMark mark) {
        if (this.marks == null) {
            this.marks = new ArrayList<PdfMark>();
        }
        this.marks.add(mark);
    }

    public boolean getForceBlobResult() {
        return this.forceBlobResult;
    }

    public void setForceBlobResult(boolean forceBlobResult) {
        this.forceBlobResult = forceBlobResult;
    }

    public boolean isPreserveSignaturesVisualRepresentation() {
        return this.preserveSignaturesVisualRepresentation;
    }

    public void setPreserveSignaturesVisualRepresentation(boolean preserveSignaturesVisualRepresentation) {
        this.preserveSignaturesVisualRepresentation = preserveSignaturesVisualRepresentation;
    }
}

