/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.PkiBrazilCertificateModel;
import com.lacunasoftware.restpki.PkiBrazilCertificateTypes;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PkiBrazilCertificateFields {
    private PkiBrazilCertificateTypes certificateType;
    private String cpf;
    private String cnpj;
    private String responsavel;
    private Date dateOfBirth;
    private String companyName;
    private String rgNumero;
    private String rgEmissor;
    private String rgEmissorUF;
    private String oabNumero;
    private String oabUF;

    PkiBrazilCertificateFields(PkiBrazilCertificateModel model) {
        this.certificateType = PkiBrazilCertificateTypes.valueOf(model.getCertificateType().toString());
        this.cpf = model.getCpf();
        this.cnpj = model.getCnpj();
        this.responsavel = model.getResponsavel();
        if (model.getDateOfBirth() != null) {
            try {
                this.dateOfBirth = new SimpleDateFormat("yyyy-MM-dd").parse(model.getDateOfBirth());
            }
            catch (ParseException e) {
                throw new RuntimeException("Could not parse dateOfBirth: " + model.getDateOfBirth(), e);
            }
        }
        this.companyName = model.getCompanyName();
        this.rgNumero = model.getRgNumero();
        this.rgEmissor = model.getRgEmissor();
        this.rgEmissorUF = model.getRgEmissorUF();
        this.oabNumero = model.getOabNumero();
        this.oabUF = model.getOabUF();
    }

    public PkiBrazilCertificateTypes getCertificateType() {
        return this.certificateType;
    }

    public void setCertificateType(PkiBrazilCertificateTypes certificateType) {
        this.certificateType = certificateType;
    }

    public String getCpf() {
        return this.cpf;
    }

    public String getCpfFormatted() {
        if (this.cpf == null || this.cpf.length() == 0) {
            return "";
        }
        if (!this.cpf.matches("^\\d{11}$")) {
            return this.cpf;
        }
        return String.format("%s.%s.%s-%s", this.cpf.substring(0, 3), this.cpf.substring(3, 6), this.cpf.substring(6, 9), this.cpf.substring(9));
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public String getCnpjFormatted() {
        if (this.cnpj == null || this.cnpj.length() == 0) {
            return "";
        }
        if (!this.cnpj.matches("^\\d{14}$")) {
            return this.cnpj;
        }
        return String.format("%s.%s.%s/%s-%s", this.cnpj.substring(0, 2), this.cnpj.substring(2, 5), this.cnpj.substring(5, 8), this.cnpj.substring(8, 12), this.cnpj.substring(12));
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getResponsavel() {
        return this.responsavel;
    }

    public void setResponsavel(String responsavel) {
        this.responsavel = responsavel;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getRGNumero() {
        return this.rgNumero;
    }

    public void setRGNumero(String rgNumero) {
        this.rgNumero = rgNumero;
    }

    public String getRGEmissor() {
        return this.rgEmissor;
    }

    public void setRGEmissor(String rgEmissor) {
        this.rgEmissor = rgEmissor;
    }

    public String getRGEmissorUF() {
        return this.rgEmissorUF;
    }

    public void setRGEmissorUF(String rgEmissorUF) {
        this.rgEmissorUF = rgEmissorUF;
    }

    public String getOabNumero() {
        return this.oabNumero;
    }

    public void setOabNumero(String oabNumero) {
        this.oabNumero = oabNumero;
    }

    public String getOabUF() {
        return this.oabUF;
    }

    public void setOabUF(String oabUF) {
        this.oabUF = oabUF;
    }
}

