/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.lacunasoftware.restpki.ErrorCodes;
import com.lacunasoftware.restpki.ErrorModel;
import com.lacunasoftware.restpki.RestDecodeException;
import com.lacunasoftware.restpki.RestErrorException;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestGeneralErrorModel;
import com.lacunasoftware.restpki.RestPkiException;
import com.lacunasoftware.restpki.RestResourceNotFoundException;
import com.lacunasoftware.restpki.RestResourceNotFoundModel;
import com.lacunasoftware.restpki.RestUnreachableException;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.ValidationException;
import com.lacunasoftware.restpki.ValidationResults;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.util.Map;
import org.threeten.bp.OffsetDateTime;
import org.threeten.bp.format.DateTimeFormatter;

class RestClient {
    private String endpointUri;
    private String authToken;
    private Proxy proxy;
    private String libVersion;

    public RestClient(String endpointUri) {
        this(endpointUri, null, null);
    }

    public RestClient(String endpointUri, String authToken) {
        this(endpointUri, authToken, null);
    }

    public RestClient(String endpointUri, Proxy proxy) {
        this(endpointUri, null, proxy);
    }

    public RestClient(String endpointUri, String authToken, Proxy proxy) {
        this.endpointUri = endpointUri;
        this.authToken = authToken;
        this.proxy = proxy;
        this.libVersion = "1.15.7";
    }

    public <TResponse> TResponse get(String requestUri, Class<TResponse> responseType) throws RestException {
        TResponse response;
        HttpURLConnection conn;
        String verb = "GET";
        String url = this.endpointUri + requestUri;
        try {
            URL urlObj = new URL(url);
            conn = this.proxy != null ? (HttpURLConnection)urlObj.openConnection(this.proxy) : (HttpURLConnection)urlObj.openConnection();
            conn.setRequestMethod(verb);
            conn.setRequestProperty("Accept", "application/json");
            if (this.authToken != null) {
                conn.setRequestProperty("Authorization", "Bearer " + this.authToken);
                conn.setRequestProperty("X-RestPki-Client", "Java 7+ " + this.libVersion);
            }
        }
        catch (Exception e) {
            throw new RestUnreachableException(verb, url, e);
        }
        this.checkResponse(verb, url, conn);
        try {
            response = this.readResponse(conn, responseType);
        }
        catch (Exception e) {
            throw new RestDecodeException(verb, url, e);
        }
        conn.disconnect();
        return response;
    }

    public InputStream getStream(String requestUri) throws RestException {
        String verb = "GET";
        String url = this.endpointUri + requestUri;
        try {
            URL urlObj = new URL(url);
            HttpURLConnection conn = this.proxy != null ? (HttpURLConnection)urlObj.openConnection(this.proxy) : (HttpURLConnection)urlObj.openConnection();
            conn.setRequestMethod(verb);
            return conn.getInputStream();
        }
        catch (Exception e) {
            throw new RestUnreachableException(verb, url, e);
        }
    }

    public <TRequest, TResponse> TResponse post(String requestUri, TRequest request, Class<TResponse> responseType) throws RestException {
        HttpURLConnection conn;
        String verb = "POST";
        String url = this.endpointUri + requestUri;
        try {
            URL urlObj = new URL(url);
            conn = this.proxy != null ? (HttpURLConnection)urlObj.openConnection(this.proxy) : (HttpURLConnection)urlObj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(verb);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (this.authToken != null) {
                conn.setRequestProperty("Authorization", "Bearer " + this.authToken);
                conn.setRequestProperty("X-RestPki-Client", "Java 7+ " + this.libVersion);
            }
            OutputStream outStream = conn.getOutputStream();
            if (request != null) {
                new ObjectMapper().writeValue(outStream, request);
            }
            outStream.close();
        }
        catch (Exception e) {
            throw new RestUnreachableException(verb, url, e);
        }
        this.checkResponse(verb, url, conn);
        TResponse response = null;
        try {
            if (responseType != null) {
                response = this.readResponse(conn, responseType);
            }
        }
        catch (Exception e) {
            throw new RestDecodeException(verb, url, e);
        }
        conn.disconnect();
        return response;
    }

    public String postAndReturnETag(String requestUri, Map<String, byte[]> headers, byte[] buffer, int nRead) throws RestException {
        HttpURLConnection conn;
        String verb = "POST";
        String url = this.endpointUri + requestUri;
        try {
            URL urlObj = new URL(url);
            conn = this.proxy != null ? (HttpURLConnection)urlObj.openConnection(this.proxy) : (HttpURLConnection)urlObj.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod(verb);
            conn.setRequestProperty("Content-Type", "application/json");
            for (String property : headers.keySet()) {
                conn.setRequestProperty(property, Util.encodeBase64(headers.get(property)));
            }
            if (this.authToken != null) {
                conn.setRequestProperty("Authorization", "Bearer " + this.authToken);
                conn.setRequestProperty("X-RestPki-Client", "Java 7+ " + this.libVersion);
            }
            OutputStream outStream = conn.getOutputStream();
            if (buffer != null) {
                outStream.write(buffer, 0, nRead);
            }
            outStream.close();
        }
        catch (Exception e) {
            throw new RestUnreachableException(verb, url, e);
        }
        this.checkResponse(verb, url, conn);
        String response = conn.getHeaderField("ETag");
        conn.disconnect();
        return response;
    }

    private void checkResponse(String verb, String url, HttpURLConnection conn) throws RestException {
        int statusCode;
        try {
            statusCode = conn.getResponseCode();
        }
        catch (Exception e) {
            throw new RestUnreachableException(verb, url, e);
        }
        if (statusCode < 200 || statusCode > 299) {
            RestException ex = null;
            try {
                if (statusCode == 404) {
                    RestResourceNotFoundModel model = this.readErrorResponse(conn, RestResourceNotFoundModel.class);
                    if (model != null) {
                        ex = !Util.isNullOrEmpty(model.resourceName) && !Util.isNullOrEmpty(model.resourceId) ? new RestResourceNotFoundException(verb, url, model.resourceName, model.resourceId) : new RestErrorException(verb, url, statusCode, model.message);
                    }
                } else if (statusCode == 422) {
                    ErrorModel errorModel = this.readErrorResponse(conn, ErrorModel.class);
                    ErrorCodes code = null;
                    if (ErrorCodes.exists(errorModel.code)) {
                        code = ErrorCodes.get(errorModel.code);
                    }
                    ex = code != null ? (code.equals((Object)ErrorCodes.ValidationError) ? new ValidationException(verb, url, new ValidationResults(errorModel.validationResults)) : new RestPkiException(verb, url, code, errorModel.detail)) : new RestPkiException(verb, url, errorModel.code, errorModel.detail);
                } else {
                    RestGeneralErrorModel model = this.readErrorResponse(conn, RestGeneralErrorModel.class);
                    if (model != null && !Util.isNullOrEmpty(model.message)) {
                        ex = new RestErrorException(verb, url, statusCode, model.message);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ex == null) {
                ex = new RestErrorException(verb, url, statusCode);
            }
            throw ex;
        }
    }

    private <T> T readResponse(HttpURLConnection conn, Class<T> valueType) throws IOException {
        InputStream inStream = conn.getInputStream();
        Object response = this.getJackson().readValue(inStream, valueType);
        inStream.close();
        return (T)response;
    }

    private <T> T readErrorResponse(HttpURLConnection conn, Class<T> valueType) throws IOException {
        InputStream inStream = conn.getErrorStream();
        Object response = this.getJackson().readValue(inStream, valueType);
        inStream.close();
        return (T)response;
    }

    protected ObjectMapper getJackson() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.registerModule((Module)new JavaTimeModule());
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new OffsetDateTimeDeserializer());
        objectMapper.registerModule((Module)simpleModule);
        return objectMapper;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    protected class OffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        protected OffsetDateTimeDeserializer() {
        }

        public OffsetDateTime deserialize(JsonParser json, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            String dateString = json.getValueAsString();
            return OffsetDateTime.parse((CharSequence)dateString, (DateTimeFormatter)DateTimeFormatter.ISO_DATE_TIME);
        }
    }
}

