/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.Util;

public class RestErrorException
extends RestException {
    private int statusCode;
    private String errorMessage;

    RestErrorException(String verb, String url, int statusCode) {
        this(verb, url, statusCode, null);
    }

    RestErrorException(String verb, String url, int statusCode, String errorMessage) {
        super(RestErrorException.formatExceptionMessage(verb, url, statusCode, errorMessage), verb, url);
        this.statusCode = statusCode;
        this.errorMessage = errorMessage;
    }

    private static String formatExceptionMessage(String verb, String url, int statusCode, String errorMessage) {
        if (Util.isNullOrEmpty(errorMessage)) {
            return String.format("REST action %s %s returned HTTP error %d", verb, url, statusCode);
        }
        return String.format("REST action %s %s returned HTTP error %d: %s", verb, url, statusCode, errorMessage);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

