/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.Apis;
import com.lacunasoftware.restpki.Authentication;
import com.lacunasoftware.restpki.BlobReference;
import com.lacunasoftware.restpki.MultipartUploadBeginResponse;
import com.lacunasoftware.restpki.MultipartUploadEndRequest;
import com.lacunasoftware.restpki.RestClient;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.SystemInfo;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.Version;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RestPkiClient {
    private String endpointUrl;
    private String authToken;
    private Proxy proxy;
    private boolean multipartUploadDoubleCheck;
    private int multipartUploadThreshold = 0x500000;
    private Version restPkiVersion;
    private static Map<String, Version> endpointVersions = new HashMap<String, Version>();

    public RestPkiClient(String endpointUrl, String authToken) {
        this(endpointUrl, authToken, null);
    }

    public RestPkiClient(String endpointUrl, String authToken, Proxy proxy) {
        this.endpointUrl = endpointUrl;
        this.authToken = authToken;
        this.proxy = proxy;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Deprecated
    public boolean getMultipartUploadDoubleCheck() {
        return this.multipartUploadDoubleCheck;
    }

    public boolean isMultipartUploadDoubleCheck() {
        return this.multipartUploadDoubleCheck;
    }

    public void setMultipartUploadDoubleCheck(boolean multipartUploadDoubleCheck) {
        this.multipartUploadDoubleCheck = multipartUploadDoubleCheck;
    }

    public int getMultipartUploadThreshold() {
        return this.multipartUploadThreshold;
    }

    public void setMultipartUploadThreshold(int multipartUploadThreshold) {
        this.multipartUploadThreshold = multipartUploadThreshold;
    }

    public Version getRestPkiVersion() {
        return this.restPkiVersion;
    }

    public void setRestPkiVersion(Version restPkiVersion) {
        this.restPkiVersion = restPkiVersion;
    }

    RestClient getRestClient() {
        return new RestClient(this.endpointUrl, this.authToken, this.proxy);
    }

    public Authentication getAuthentication() {
        return new Authentication(this);
    }

    Object uploadOrRead(InputStream stream) throws IOException, RestException {
        int apiVersion = this.getApiVersion(Apis.MultipartUpload);
        switch (apiVersion) {
            case 0: {
                return this.read(stream);
            }
        }
        return this.upload(stream);
    }

    byte[] read(InputStream stream) throws IOException {
        return Util.readStream(stream);
    }

    String upload(InputStream stream) throws RestException {
        MultipartUploadBeginResponse beginResponse = this.getRestClient().post("Api/MultipartUploads", null, MultipartUploadBeginResponse.class);
        String blobToken = beginResponse.getBlobToken();
        String blobUri = String.format("Api/MultipartUploads/%s", blobToken);
        int partSize = beginResponse.getPartSize();
        byte[] buffer = new byte[partSize];
        ArrayList<String> partETags = new ArrayList<String>();
        int partNumber = 0;
        MessageDigest streamHasher = null;
        DigestInputStream digestStream = null;
        try {
            int nRead;
            streamHasher = MessageDigest.getInstance("MD5");
            digestStream = new DigestInputStream(stream, streamHasher);
            while ((nRead = digestStream.read(buffer, 0, partSize)) != -1) {
                HashMap<String, byte[]> headers = new HashMap<String, byte[]>();
                MessageDigest partHasher = MessageDigest.getInstance("MD5");
                partHasher.update(buffer, 0, nRead);
                headers.put("Content-MD5", partHasher.digest());
                String partETag = this.getRestClient().postAndReturnETag(String.format("%s/%s", blobUri, partNumber), headers, buffer, nRead);
                partETags.add(partETag);
                ++partNumber;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        MultipartUploadEndRequest endRequest = new MultipartUploadEndRequest();
        endRequest.setPartETags(partETags);
        endRequest.setCompleteMD5(this.multipartUploadDoubleCheck ? streamHasher.digest() : null);
        this.getRestClient().post(blobUri, endRequest, null);
        return blobToken;
    }

    public BlobReference uploadFile(InputStream stream) throws RestException {
        String blobToken = this.upload(stream);
        return new BlobReference(blobToken);
    }

    public BlobReference uploadFile(Path path) throws IOException, RestException {
        return this.uploadFile(path.toString());
    }

    public BlobReference uploadFile(String path) throws IOException, RestException {
        FileInputStream stream = new FileInputStream(path);
        String blobToken = this.upload(stream);
        ((InputStream)stream).close();
        return new BlobReference(blobToken);
    }

    public BlobReference uploadFile(byte[] content) throws IOException, RestException {
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        String blobToken = this.upload(stream);
        ((InputStream)stream).close();
        return new BlobReference(blobToken);
    }

    int getApiVersion(Apis api) throws RestException {
        Version v = this.restPkiVersion;
        if (v == null) {
            v = this.tryGetEndpointVersion(this.endpointUrl);
        }
        switch (api) {
            case StartCades: {
                if (v.isGreaterThanOrEqualTo(new Version("1.11"))) {
                    return 3;
                }
                if (v.isGreaterThanOrEqualTo(new Version("1.10"))) {
                    return 2;
                }
                return 1;
            }
            case CompleteCades: {
                if (v.isGreaterThanOrEqualTo(new Version("1.11"))) {
                    return 2;
                }
                return 1;
            }
            case StartPades: {
                if (v.isGreaterThanOrEqualTo(new Version("1.11"))) {
                    return 2;
                }
                return 1;
            }
            case CompletePades: {
                if (v.isGreaterThanOrEqualTo(new Version("1.11"))) {
                    return 2;
                }
                return 1;
            }
            case MultipartUpload: {
                if (v.isGreaterThanOrEqualTo(new Version("1.11"))) {
                    return 1;
                }
                return 0;
            }
            case AddPdfMarks: {
                if (v.isGreaterThanOrEqualTo(new Version("1.13"))) {
                    return 1;
                }
                return 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    private Version tryGetEndpointVersion(String endpointUri) throws RestException {
        if (endpointVersions.containsKey(endpointUri)) {
            return endpointVersions.get(endpointUri);
        }
        SystemInfo response = this.getRestClient().get("Api/System/Info", SystemInfo.class);
        Version version = new Version(response.getProductVersion());
        endpointVersions.put(endpointUri, version);
        return version;
    }
}

