/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.ErrorCodes;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.Util;

public class RestPkiException
extends RestException {
    private ErrorCodes errorCode;
    private String errorCodeStr;
    private String detail;

    RestPkiException(String verb, String url, ErrorCodes errorCode, String detail) {
        super(RestPkiException.formatExceptionMessage(verb, url, errorCode, detail), verb, url);
        this.errorCode = errorCode;
        this.errorCodeStr = errorCode.name();
        this.detail = detail;
    }

    RestPkiException(String verb, String url, String errorCode, String detail) {
        super(RestPkiException.formatExceptionMessage(verb, url, errorCode, detail), verb, url);
        this.errorCodeStr = errorCode;
        this.detail = detail;
    }

    private static String formatExceptionMessage(String verb, String url, ErrorCodes errorCode, String detail) {
        if (Util.isNullOrEmpty(detail)) {
            return String.format("REST PKI action %s %s error: %s", new Object[]{verb, url, errorCode});
        }
        return String.format("REST PKI action %s %s error: %s (%s)", new Object[]{verb, url, errorCode, detail});
    }

    private static String formatExceptionMessage(String verb, String url, String errorCode, String detail) {
        if (Util.isNullOrEmpty(detail)) {
            return String.format("REST PKI action %s %s error: %s", verb, url, errorCode);
        }
        return String.format("REST PKI action %s %s error: %s (%s)", verb, url, errorCode, detail);
    }

    public ErrorCodes getErrorCode() {
        return this.errorCode;
    }

    public String getErrorCodeStr() {
        return this.errorCodeStr;
    }

    public String getDetail() {
        return this.detail;
    }
}

