/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.FileModel;
import com.lacunasoftware.restpki.OpenSignatureRequestModel;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SecurityContext;
import com.lacunasoftware.restpki.SignaturePolicy;
import com.lacunasoftware.restpki.SignaturePolicyCatalog;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.UUID;

public abstract class SignatureExplorer {
    protected RestPkiClient client;
    protected byte[] signatureFileContent;
    protected boolean validate;
    protected String defaultSignaturePolicyId;
    protected SignaturePolicyCatalog acceptableExplicitPolicies;
    protected String securityContextId;
    protected boolean ignoreRevocationStatusUnknown = false;
    protected boolean trustUncertifiedSigningTime = false;

    public SignatureExplorer(RestPkiClient client) {
        this.client = client;
    }

    public byte[] getSignatureFile() {
        return this.signatureFileContent;
    }

    public void setSignatureFile(byte[] content) {
        this.signatureFileContent = content;
    }

    public void setSignatureFile(String path) throws IOException {
        this.setSignatureFile(Paths.get(path, new String[0]));
    }

    public void setSignatureFile(Path path) throws IOException {
        this.signatureFileContent = Files.readAllBytes(path);
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getDefaultSignaturePolicyId() {
        return this.defaultSignaturePolicyId;
    }

    public void setDefaultSignaturePolicy(SignaturePolicy signaturePolicy) {
        this.defaultSignaturePolicyId = signaturePolicy.getId();
    }

    public SignaturePolicyCatalog getAcceptableExplicitPolicies() {
        return this.acceptableExplicitPolicies;
    }

    public void setAcceptableExplicitPolicies(SignaturePolicyCatalog policyCatalog) {
        this.acceptableExplicitPolicies = policyCatalog;
    }

    public String getSecurityContextId() {
        return this.securityContextId;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContextId = securityContext.getId();
    }

    public RestPkiClient getClient() {
        return this.client;
    }

    public void setClient(RestPkiClient client) {
        this.client = client;
    }

    public void setIgnoreRevocationStatusUnknown(boolean ignoreRevocationStatusUnknown) {
        this.ignoreRevocationStatusUnknown = ignoreRevocationStatusUnknown;
    }

    public boolean isTrustUncertifiedSigningTime() {
        return this.trustUncertifiedSigningTime;
    }

    public void setTrustUncertifiedSigningTime(boolean trustUncertifiedSigningTime) {
        this.trustUncertifiedSigningTime = trustUncertifiedSigningTime;
    }

    protected OpenSignatureRequestModel getRequest(String fileMimeType) {
        OpenSignatureRequestModel request = new OpenSignatureRequestModel();
        FileModel file = new FileModel();
        file.setContent(this.signatureFileContent);
        file.setMimeType(fileMimeType);
        request.setFile(file);
        request.setValidate(this.validate);
        if (this.defaultSignaturePolicyId != null) {
            request.setDefaultSignaturePolicyId(UUID.fromString(this.defaultSignaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setTrustUncertifiedSigningTime(this.trustUncertifiedSigningTime);
        if (this.acceptableExplicitPolicies != null) {
            ArrayList<UUID> policyIds = new ArrayList<UUID>();
            for (SignaturePolicy policy : this.acceptableExplicitPolicies.getPolicies()) {
                policyIds.add(UUID.fromString(policy.getId()));
            }
            request.setAcceptableExplicitPolicies(policyIds);
        }
        return request;
    }
}

