/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.BlobReference;
import com.lacunasoftware.restpki.FileRef;
import com.lacunasoftware.restpki.FileResult;
import com.lacunasoftware.restpki.OpenSignatureRequestModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SecurityContext;
import com.lacunasoftware.restpki.SignaturePolicy;
import com.lacunasoftware.restpki.SignaturePolicyCatalog;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.UUID;

public abstract class SignatureExplorer2 {
    protected RestPkiClient client;
    FileRef signatureFile;
    protected boolean validate;
    protected String securityContextId;
    protected String defaultSignaturePolicyId;
    protected SignaturePolicyCatalog acceptableExplicitPolicies;
    protected boolean ignoreRevocationStatusUnknown = false;
    protected boolean trustUncertifiedSigningTime = false;

    public SignatureExplorer2(RestPkiClient client) {
        this.client = client;
    }

    public FileRef getSignatureFile() {
        return this.signatureFile;
    }

    public void setSignatureFile(String path) {
        this.setSignatureFile(Paths.get(path, new String[0]));
    }

    public void setSignatureFile(Path path) {
        this.signatureFile = FileRef.fromFile(path);
    }

    public void setSignatureFile(InputStream stream) {
        this.signatureFile = FileRef.fromStream(stream);
    }

    public void setSignatureFile(byte[] content) {
        this.signatureFile = FileRef.fromContent(content);
    }

    public void setSignatureFile(BlobReference fileBlob) {
        this.signatureFile = FileRef.fromBlob(fileBlob);
    }

    public void setSignatureFile(FileResult fileResult) {
        this.signatureFile = FileRef.fromResult(fileResult);
    }

    public boolean isValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public String getDefaultSignaturePolicyId() {
        return this.defaultSignaturePolicyId;
    }

    public void setDefaultSignaturePolicy(SignaturePolicy signaturePolicy) {
        this.defaultSignaturePolicyId = signaturePolicy.getId();
    }

    public SignaturePolicyCatalog getAcceptableExplicitPolicies() {
        return this.acceptableExplicitPolicies;
    }

    public void setAcceptableExplicitPolicies(SignaturePolicyCatalog policyCatalog) {
        this.acceptableExplicitPolicies = policyCatalog;
    }

    public String getSecurityContextId() {
        return this.securityContextId;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContextId = securityContext.getId();
    }

    public RestPkiClient getClient() {
        return this.client;
    }

    public void setClient(RestPkiClient client) {
        this.client = client;
    }

    public void setIgnoreRevocationStatusUnknown(boolean ignoreRevocationStatusUnknown) {
        this.ignoreRevocationStatusUnknown = ignoreRevocationStatusUnknown;
    }

    public boolean isTrustUncertifiedSigningTime() {
        return this.trustUncertifiedSigningTime;
    }

    public void setTrustUncertifiedSigningTime(boolean trustUncertifiedSigningTime) {
        this.trustUncertifiedSigningTime = trustUncertifiedSigningTime;
    }

    protected OpenSignatureRequestModel fillRequest(OpenSignatureRequestModel request) throws RestException, IOException {
        request.setValidate(this.validate);
        if (this.defaultSignaturePolicyId != null) {
            request.setDefaultSignaturePolicyId(UUID.fromString(this.defaultSignaturePolicyId));
        }
        if (this.securityContextId != null) {
            request.setSecurityContextId(UUID.fromString(this.securityContextId));
        }
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setTrustUncertifiedSigningTime(this.trustUncertifiedSigningTime);
        if (this.acceptableExplicitPolicies != null) {
            ArrayList<UUID> policyIds = new ArrayList<UUID>();
            for (SignaturePolicy policy : this.acceptableExplicitPolicies.getPolicies()) {
                policyIds.add(UUID.fromString(policy.getId()));
            }
            request.setAcceptableExplicitPolicies(policyIds);
        }
        request.setFile(this.signatureFile.uploadOrReference(this.client));
        return request;
    }
}

