/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.CompleteSignatureRequest;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureResult;
import com.lacunasoftware.restpki.SignatureResultModel;

public abstract class SignatureFinisher2 {
    protected RestPkiClient client;
    protected String token;
    protected byte[] signature;
    protected Boolean forceBlobResult;

    public SignatureFinisher2(RestPkiClient client) {
        this.client = client;
        this.forceBlobResult = false;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public Boolean getForceBlobResult() {
        return this.forceBlobResult;
    }

    public void setForceBlobResult(Boolean forceBlobResult) {
        this.forceBlobResult = forceBlobResult;
    }

    public RestPkiClient getClient() {
        return this.client;
    }

    public void setClient(RestPkiClient client) {
        this.client = client;
    }

    public SignatureResult finish() throws RestException {
        if (this.token == null) {
            throw new RuntimeException("The token was not set");
        }
        this.checkCompatibility();
        CompleteSignatureRequest request = new CompleteSignatureRequest();
        request.setForceBlobResult(this.forceBlobResult);
        request.setSignature(this.signature);
        SignatureResultModel response = this.client.getRestClient().post(this.getApiRoute(), request, SignatureResultModel.class);
        return new SignatureResult(this.client, response.getSignatureFile(), response.getCertificate(), response.getCallbackArgument());
    }

    protected abstract void checkCompatibility() throws RestException;

    protected abstract String getApiRoute();
}

