/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.ClientSideSignatureInstructions;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SecurityContext;
import com.lacunasoftware.restpki.SignaturePolicy;

public abstract class SignatureStarter {
    protected RestPkiClient client;
    protected String certificate;
    protected String signaturePolicyId;
    protected String securityContextId;
    protected String callbackArgument;
    protected boolean ignoreRevocationStatusUnknown = false;
    protected boolean done;
    protected PKCertificate certificateInfo;

    public SignatureStarter(RestPkiClient client) {
        this.client = client;
        this.done = false;
    }

    public String getSignerCertificate() {
        return this.certificate;
    }

    public void setSignerCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getSignaturePolicyId() {
        return this.signaturePolicyId;
    }

    public void setSignaturePolicy(SignaturePolicy signaturePolicy) {
        this.signaturePolicyId = signaturePolicy.getId();
    }

    public String getSecurityContext() {
        return this.securityContextId;
    }

    @Deprecated
    public String getSecurityContextId() {
        return this.securityContextId;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContextId = securityContext.getId();
    }

    @Deprecated
    public String setSecurityContextId() {
        return this.securityContextId;
    }

    public String getCallbackArgument() {
        return this.callbackArgument;
    }

    public void setCallbackArgument(String argument) {
        this.callbackArgument = argument;
    }

    public RestPkiClient getClient() {
        return this.client;
    }

    public void setClient(RestPkiClient client) {
        this.client = client;
    }

    public void setIgnoreRevocationStatusUnknown(boolean ignoreRevocationStatusUnknown) {
        this.ignoreRevocationStatusUnknown = ignoreRevocationStatusUnknown;
    }

    public abstract ClientSideSignatureInstructions start() throws RestException;

    public abstract String startWithWebPki() throws RestException;

    public PKCertificate getCertificateInfo() {
        if (!this.done) {
            throw new RuntimeException("The method cetCertificateInfo() can only be called after calling one of the start methods");
        }
        return this.certificateInfo;
    }
}

