/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SecurityContext;
import com.lacunasoftware.restpki.SignaturePolicy;
import com.lacunasoftware.restpki.SignatureStartResult;
import com.lacunasoftware.restpki.SignatureStartWithWebPkiResult;
import com.lacunasoftware.restpki.Util;
import java.io.IOException;

public abstract class SignatureStarter2 {
    protected RestPkiClient client;
    protected String certificateBase64;
    protected String signaturePolicyId;
    protected String securityContextId;
    protected String callbackArgument;
    protected boolean ignoreRevocationStatusUnknown = false;

    public SignatureStarter2(RestPkiClient client) {
        this.client = client;
    }

    public void setSignerCertificateRaw(byte[] certificateRaw) {
        this.certificateBase64 = Util.encodeBase64(certificateRaw);
    }

    public void setSignerCertificateBase64(String certificateBase64) {
        this.certificateBase64 = certificateBase64;
    }

    @Deprecated
    public void setSignerCertificate(String certificateBase64) {
        this.setSignerCertificateBase64(certificateBase64);
    }

    public void setSignaturePolicy(SignaturePolicy signaturePolicy) {
        this.signaturePolicyId = signaturePolicy.getId();
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContextId = securityContext.getId();
    }

    public void setCallbackArgument(String argument) {
        this.callbackArgument = argument;
    }

    public void setIgnoreRevocationStatusUnknown(boolean ignoreRevocationStatusUnknown) {
        this.ignoreRevocationStatusUnknown = ignoreRevocationStatusUnknown;
    }

    public abstract SignatureStartResult start() throws RestException, IOException;

    public abstract SignatureStartWithWebPkiResult startWithWebPki() throws RestException, IOException;
}

