/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.restpki.ColorModel;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

class Util {
    Util() {
    }

    static String repeatChar(char c, int count) {
        char[] array = new char[count];
        Arrays.fill(array, c);
        return new String(array);
    }

    static String join(String delimiter, List<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < elements.size(); ++i) {
            sb.append(elements.get(i));
            if (i >= elements.size() - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static byte[] readStream(InputStream stream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    static byte[] decodeBase64(String s) {
        return (byte[])new ObjectMapper().convertValue((Object)s, byte[].class);
    }

    static String encodeBase64(byte[] content) {
        return (String)new ObjectMapper().convertValue((Object)content, String.class);
    }

    static Date parseApiDate(String dateStr) {
        Date date;
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
        try {
            date = fmt.parse(dateStr);
        }
        catch (ParseException ex) {
            date = null;
        }
        return date;
    }

    static ColorModel convertColorToModel(Color color) {
        ColorModel model = new ColorModel();
        model.setAlpha((double)color.getAlpha() / 2.55);
        model.setRed(color.getRed());
        model.setGreen(color.getGreen());
        model.setBlue(color.getBlue());
        return model;
    }
}

