/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.ValidationItemModel;
import com.lacunasoftware.restpki.ValidationItemTypes;
import com.lacunasoftware.restpki.ValidationResults;

public class ValidationItem {
    private ValidationItemTypes type;
    private String message;
    private String detail;
    private ValidationResults innerValidationResults;

    ValidationItem(ValidationItemModel model) {
        this.type = ValidationItemTypes.valueOf(model.getType().toString());
        this.message = model.getMessage();
        this.detail = model.getDetail();
        if (model.getInnerValidationResults() != null) {
            this.innerValidationResults = new ValidationResults(model.getInnerValidationResults());
        }
    }

    public ValidationItemTypes getType() {
        return this.type;
    }

    public void setType(ValidationItemTypes type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public ValidationResults getInnerValidationResults() {
        return this.innerValidationResults;
    }

    public void setInnerValidationResults(ValidationResults innerValidationResults) {
        this.innerValidationResults = innerValidationResults;
    }

    public String toString() {
        return this.toString(0);
    }

    String toString(int identationLevel) {
        StringBuilder text = new StringBuilder();
        text.append(this.message);
        if (!Util.isNullOrEmpty(this.detail)) {
            text.append(String.format(" (%s)", this.detail));
        }
        if (this.innerValidationResults != null) {
            text.append('\n');
            text.append(this.innerValidationResults.toString(identationLevel + 1));
        }
        return text.toString();
    }
}

