/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.CadesTimestamp;
import com.lacunasoftware.restpki.CadesTimestampModel;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.SignatureAlgorithmAndValue;
import com.lacunasoftware.restpki.SignaturePolicyIdentifier;
import com.lacunasoftware.restpki.ValidationResults;
import com.lacunasoftware.restpki.XmlElementInfo;
import com.lacunasoftware.restpki.XmlSignatureModel;
import com.lacunasoftware.restpki.XmlSignedEntityTypes;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class XmlSignature {
    private XmlSignedEntityTypes type;
    private XmlElementInfo signedElement;
    private SignatureAlgorithmAndValue signature;
    private SignaturePolicyIdentifier signaturePolicy;
    private PKCertificate certificate;
    private Date signingTime;
    private Date certifiedDateReference;
    private List<CadesTimestamp> timestamps = new ArrayList<CadesTimestamp>();
    private ValidationResults validationResults;

    XmlSignature(XmlSignatureModel model) {
        if (model.getSignedElement() != null) {
            this.signedElement = new XmlElementInfo(model.getSignedElement());
        }
        this.type = XmlSignedEntityTypes.valueOf(model.getType().toString());
        this.signature = new SignatureAlgorithmAndValue(model.getSignature());
        if (model.getSignaturePolicy() != null) {
            this.signaturePolicy = new SignaturePolicyIdentifier(model.getSignaturePolicy());
        }
        this.certificate = new PKCertificate(model.getCertificate());
        this.signingTime = model.getSigningTime();
        this.certifiedDateReference = model.getCertifiedDateReference();
        for (CadesTimestampModel timestamp : model.getTimestamps()) {
            this.timestamps.add(new CadesTimestamp(timestamp));
        }
        if (model.getValidationResults() != null) {
            this.validationResults = new ValidationResults(model.getValidationResults());
        }
    }

    public XmlSignedEntityTypes getType() {
        return this.type;
    }

    public void setType(XmlSignedEntityTypes type) {
        this.type = type;
    }

    public XmlElementInfo getSignedElement() {
        return this.signedElement;
    }

    public void setSignedElement(XmlElementInfo signedElement) {
        this.signedElement = signedElement;
    }

    public SignatureAlgorithmAndValue getSignature() {
        return this.signature;
    }

    public void setSignature(SignatureAlgorithmAndValue signature) {
        this.signature = signature;
    }

    public SignaturePolicyIdentifier getSignaturePolicy() {
        return this.signaturePolicy;
    }

    public void setSignaturePolicy(SignaturePolicyIdentifier signaturePolicy) {
        this.signaturePolicy = signaturePolicy;
    }

    public PKCertificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(PKCertificate certificate) {
        this.certificate = certificate;
    }

    public Date getSigningTime() {
        return this.signingTime;
    }

    public void setSigningTime(Date signingTime) {
        this.signingTime = signingTime;
    }

    public Date getCertifiedDateReference() {
        return this.certifiedDateReference;
    }

    public void setCertifiedDateReference(Date certifiedDateReference) {
        this.certifiedDateReference = certifiedDateReference;
    }

    public List<CadesTimestamp> getTimestamps() {
        return this.timestamps;
    }

    public void setTimestamps(List<CadesTimestamp> timestamps) {
        this.timestamps = timestamps;
    }

    public ValidationResults getValidationResults() {
        return this.validationResults;
    }

    public void setValidationResults(ValidationResults validationResults) {
        this.validationResults = validationResults;
    }
}

