/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.OpenXmlSignatureRequestModel;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureExplorer2;
import com.lacunasoftware.restpki.SignaturePolicy;
import com.lacunasoftware.restpki.XmlIdResolutionTable;
import com.lacunasoftware.restpki.XmlSignature;
import com.lacunasoftware.restpki.XmlSignatureModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class XmlSignatureExplorer
extends SignatureExplorer2 {
    private XmlIdResolutionTable idResolutionTable;
    private static final String XML_MIME_TYPE = "application/xml";

    public XmlSignatureExplorer(RestPkiClient client) {
        super(client);
    }

    public XmlIdResolutionTable getIdResolutionTable() {
        return this.idResolutionTable;
    }

    public void setIdResolutionTable(XmlIdResolutionTable idResolutionTable) {
        this.idResolutionTable = idResolutionTable;
    }

    public List<XmlSignature> open() throws RestException, IOException {
        if (this.signatureFile == null) {
            throw new RuntimeException("The signature file to open not set");
        }
        OpenXmlSignatureRequestModel request = this.fillRequest(new OpenXmlSignatureRequestModel());
        request.setIdResolutionTable(this.idResolutionTable == null ? null : this.idResolutionTable.toModel());
        List<Object> response = Arrays.asList((Object[])this.client.getRestClient().post("Api/XmlSignatures/Open", request, XmlSignatureModel[].class));
        ArrayList<XmlSignature> signatures = new ArrayList<XmlSignature>();
        for (XmlSignatureModel xmlSignatureModel : response) {
            signatures.add(new XmlSignature(xmlSignatureModel));
        }
        return signatures;
    }

    private OpenXmlSignatureRequestModel fillRequest(OpenXmlSignatureRequestModel request) throws RestException, IOException {
        request.setValidate(this.validate);
        request.setDefaultSignaturePolicyId(UUID.fromString(this.defaultSignaturePolicyId));
        request.setSecurityContextId(UUID.fromString(this.securityContextId));
        request.setIgnoreRevocationStatusUnknown(this.ignoreRevocationStatusUnknown);
        request.setTrustUncertifiedSigningTime(this.trustUncertifiedSigningTime);
        if (this.acceptableExplicitPolicies != null) {
            ArrayList<UUID> policyIds = new ArrayList<UUID>();
            for (SignaturePolicy policy : this.acceptableExplicitPolicies.getPolicies()) {
                policyIds.add(UUID.fromString(policy.getId()));
            }
            request.setAcceptableExplicitPolicies(policyIds);
        }
        request.setFile(this.signatureFile.uploadOrReference(this.client));
        return request;
    }
}

