/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lacunasoftware.restpki.PKCertificate;
import com.lacunasoftware.restpki.RestException;
import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureFinisher;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.XmlSignaturePostSignedBytesRequest;
import com.lacunasoftware.restpki.XmlSignaturePostSignedBytesResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class XmlSignatureFinisher
extends SignatureFinisher {
    private byte[] signedXml;

    public XmlSignatureFinisher(RestPkiClient client) {
        super(client);
    }

    @Override
    public byte[] finish() throws RestException {
        XmlSignaturePostSignedBytesResponse response;
        if (this.token == null) {
            throw new RuntimeException("The token was not set");
        }
        if (this.signature == null) {
            String actionUrl = String.format("Api/XmlSignatures/%s/Finalize", this.token);
            response = this.client.getRestClient().post(actionUrl, null, XmlSignaturePostSignedBytesResponse.class);
        } else {
            XmlSignaturePostSignedBytesRequest request = new XmlSignaturePostSignedBytesRequest();
            request.setSignature(Util.decodeBase64(this.signature));
            String actionUrl = String.format("Api/XmlSignatures/%s/SignedBytes", this.token);
            response = this.client.getRestClient().post(actionUrl, request, XmlSignaturePostSignedBytesResponse.class);
        }
        this.signedXml = (byte[])new ObjectMapper().convertValue((Object)response.getSignedXml(), byte[].class);
        this.callbackArgument = response.getCallbackArgument();
        this.certificateInfo = new PKCertificate(response.getCertificate());
        this.done = true;
        return this.signedXml;
    }

    public byte[] getSignedXml() {
        if (!this.done) {
            throw new RuntimeException("The getSignedPdf() method can only be called after calling the finish() method");
        }
        return this.signedXml;
    }

    public void writeSignedXmlToFile(String path) throws IOException {
        this.writeSignedXmlToFile(Paths.get(path, new String[0]));
    }

    public void writeSignedXmlToFile(Path path) throws IOException {
        if (!this.done) {
            throw new RuntimeException("The writeSignedXmlToFile() method can only be called after calling the finish() method");
        }
        Files.write(path, this.signedXml, new OpenOption[0]);
    }
}

