/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki;

import com.lacunasoftware.restpki.RestPkiClient;
import com.lacunasoftware.restpki.SignatureStarter;
import com.lacunasoftware.restpki.Util;
import com.lacunasoftware.restpki.XmlElementLocationModel;
import com.lacunasoftware.restpki.XmlInsertionOptions;
import com.lacunasoftware.restpki.XmlNamespaceManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class XmlSignatureStarter
extends SignatureStarter {
    protected byte[] xml;
    protected String signatureElementId;
    protected XmlElementLocationModel signatureElementLocation;

    public XmlSignatureStarter(RestPkiClient client) {
        super(client);
    }

    public byte[] getXml() {
        return this.xml;
    }

    public void setXml(byte[] content) {
        this.xml = content;
    }

    public void setXml(InputStream stream) throws IOException {
        this.xml = Util.readStream(stream);
    }

    public void setXml(String path) throws IOException {
        this.setXml(Paths.get(path, new String[0]));
    }

    public void setXml(Path path) throws IOException {
        this.xml = Files.readAllBytes(path);
    }

    public String getSignatureElementId() {
        return this.signatureElementId;
    }

    public void setSignatureElementId(String id) {
        this.signatureElementId = id;
    }

    public void setSignatureElementLocation(String xpath, XmlNamespaceManager nsm, XmlInsertionOptions insertionOption) {
        this.signatureElementLocation = new XmlElementLocationModel();
        this.signatureElementLocation.setInsertionOption(XmlElementLocationModel.InsertionOptionEnum.fromValue(insertionOption.toString()));
        this.signatureElementLocation.setXPath(xpath);
        this.signatureElementLocation.setNamespaces(nsm.getNamespaces());
    }
}

