/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
class DigestAlgorithmAndValueModel {
    @JsonProperty(value="algorithm")
    private AlgorithmEnum algorithm = null;
    @JsonProperty(value="value")
    private byte[] value = null;
    @JsonProperty(value="hexValue")
    private String hexValue = null;

    DigestAlgorithmAndValueModel() {
    }

    public DigestAlgorithmAndValueModel algorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @ApiModelProperty(value="")
    public AlgorithmEnum getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(AlgorithmEnum algorithm) {
        this.algorithm = algorithm;
    }

    public DigestAlgorithmAndValueModel value(byte[] value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="")
    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public DigestAlgorithmAndValueModel hexValue(String hexValue) {
        this.hexValue = hexValue;
        return this;
    }

    @ApiModelProperty(value="")
    public String getHexValue() {
        return this.hexValue;
    }

    public void setHexValue(String hexValue) {
        this.hexValue = hexValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigestAlgorithmAndValueModel digestAlgorithmAndValueModel = (DigestAlgorithmAndValueModel)o;
        return Objects.equals((Object)this.algorithm, (Object)digestAlgorithmAndValueModel.algorithm) && Arrays.equals(this.value, digestAlgorithmAndValueModel.value) && Objects.equals(this.hexValue, digestAlgorithmAndValueModel.hexValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithm, Arrays.hashCode(this.value), this.hexValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DigestAlgorithmAndValueModel {\n");
        sb.append("    algorithm: ").append(this.toIndentedString((Object)this.algorithm)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    hexValue: ").append(this.toIndentedString(this.hexValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AlgorithmEnum {
        MD5("MD5"),
        SHA1("SHA1"),
        SHA256("SHA256"),
        SHA384("SHA384"),
        SHA512("SHA512"),
        SHA3_256("SHA3_256");

        private String value;

        private AlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AlgorithmEnum fromValue(String text) {
            for (AlgorithmEnum b : AlgorithmEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

