/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
class EventSummary {
    @JsonProperty(value="id")
    private UUID id = null;
    @JsonProperty(value="date")
    private String date = null;
    @JsonProperty(value="operation")
    private OperationEnum operation = null;
    @JsonProperty(value="success")
    private Boolean success = null;
    @JsonProperty(value="hasDetails")
    private Boolean hasDetails = null;
    @JsonProperty(value="clientLibId")
    private String clientLibId = null;
    @JsonProperty(value="clientLibVersion")
    private String clientLibVersion = null;

    EventSummary() {
    }

    public EventSummary id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public EventSummary date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public EventSummary operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(value="")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public EventSummary success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public EventSummary hasDetails(Boolean hasDetails) {
        this.hasDetails = hasDetails;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isHasDetails() {
        return this.hasDetails;
    }

    public void setHasDetails(Boolean hasDetails) {
        this.hasDetails = hasDetails;
    }

    public EventSummary clientLibId(String clientLibId) {
        this.clientLibId = clientLibId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getClientLibId() {
        return this.clientLibId;
    }

    public void setClientLibId(String clientLibId) {
        this.clientLibId = clientLibId;
    }

    public EventSummary clientLibVersion(String clientLibVersion) {
        this.clientLibVersion = clientLibVersion;
        return this;
    }

    @ApiModelProperty(value="")
    public String getClientLibVersion() {
        return this.clientLibVersion;
    }

    public void setClientLibVersion(String clientLibVersion) {
        this.clientLibVersion = clientLibVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSummary eventSummary = (EventSummary)o;
        return Objects.equals(this.id, eventSummary.id) && Objects.equals(this.date, eventSummary.date) && Objects.equals((Object)this.operation, (Object)eventSummary.operation) && Objects.equals(this.success, eventSummary.success) && Objects.equals(this.hasDetails, eventSummary.hasDetails) && Objects.equals(this.clientLibId, eventSummary.clientLibId) && Objects.equals(this.clientLibVersion, eventSummary.clientLibVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.date, this.operation, this.success, this.hasDetails, this.clientLibId, this.clientLibVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventSummary {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    hasDetails: ").append(this.toIndentedString(this.hasDetails)).append("\n");
        sb.append("    clientLibId: ").append(this.toIndentedString(this.clientLibId)).append("\n");
        sb.append("    clientLibVersion: ").append(this.toIndentedString(this.clientLibVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OperationEnum {
        ACCESSTOKENGENERATED("AccessTokenGenerated"),
        ACCESSTOKENSREVOKED("AccessTokensRevoked"),
        CERTAUTHSTARTED("CertAuthStarted"),
        CERTAUTHCOMPLETED("CertAuthCompleted"),
        PADESSIGNATURESTARTED("PadesSignatureStarted"),
        PADESSIGNATURECOMPLETED("PadesSignatureCompleted"),
        CADESSIGNATURESTARTED("CadesSignatureStarted"),
        CADESSIGNATURECOMPLETED("CadesSignatureCompleted"),
        XMLSIGNATURESTARTED("XmlSignatureStarted"),
        XMLSIGNATURECOMPLETED("XmlSignatureCompleted"),
        OPENSIGNATURE("OpenSignature"),
        ISSUETIMESTAMP("IssueTimestamp"),
        ADDPDFMARKS("AddPdfMarks"),
        GETPENDINGSIGNATURE("GetPendingSignature"),
        SETPENDINGSIGNATURE("SetPendingSignature");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OperationEnum fromValue(String text) {
            for (OperationEnum b : OperationEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

