/*
 * Decompiled with CFR 0.152.
 */
package com.lacunasoftware.restpki.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
class TransactionRequest {
    @JsonProperty(value="type")
    private List<TypeEnum> type = null;
    @JsonProperty(value="success")
    private Boolean success = null;
    @JsonProperty(value="invoiceId")
    private UUID invoiceId = null;

    TransactionRequest() {
    }

    public TransactionRequest type(List<TypeEnum> type) {
        this.type = type;
        return this;
    }

    public TransactionRequest addTypeItem(TypeEnum typeItem) {
        if (this.type == null) {
            this.type = new ArrayList<TypeEnum>();
        }
        this.type.add(typeItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<TypeEnum> getType() {
        return this.type;
    }

    public void setType(List<TypeEnum> type) {
        this.type = type;
    }

    public TransactionRequest success(Boolean success) {
        this.success = success;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public TransactionRequest invoiceId(UUID invoiceId) {
        this.invoiceId = invoiceId;
        return this;
    }

    @ApiModelProperty(example="00000000-0000-0000-0000-000000000000", value="")
    public UUID getInvoiceId() {
        return this.invoiceId;
    }

    public void setInvoiceId(UUID invoiceId) {
        this.invoiceId = invoiceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionRequest transactionRequest = (TransactionRequest)o;
        return Objects.equals(this.type, transactionRequest.type) && Objects.equals(this.success, transactionRequest.success) && Objects.equals(this.invoiceId, transactionRequest.invoiceId);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.success, this.invoiceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransactionRequest {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    success: ").append(this.toIndentedString(this.success)).append("\n");
        sb.append("    invoiceId: ").append(this.toIndentedString(this.invoiceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        PADESSIGNATURE("PadesSignature"),
        CERTAUTHENTICATION("CertAuthentication"),
        CADESSIGNATURE("CadesSignature"),
        XMLSIGNATURE("XmlSignature"),
        TIMESTAMP("Timestamp"),
        OPENSIGNATURE("OpenSignature"),
        ADDPDFMARKS("AddPdfMarks");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String text) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

